/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import jakarta.servlet.Filter;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LogoutConfigurer;
import org.springframework.security.saml2.provider.service.metadata.OpenSamlMetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.RequestMatcherMetadataResponseResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResponseResolver;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.Saml2MetadataFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class Saml2MetadataConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<Saml2LogoutConfigurer<H>, H> {
    private final ApplicationContext context;
    private Function<RelyingPartyRegistrationRepository, Saml2MetadataResponseResolver> metadataResponseResolver;

    public Saml2MetadataConfigurer(ApplicationContext context) {
        this.context = context;
    }

    public Saml2MetadataConfigurer<H> metadataUrl(String metadataUrl) {
        Assert.hasText(metadataUrl, "metadataUrl cannot be empty");
        this.metadataResponseResolver = registrations -> {
            RequestMatcherMetadataResponseResolver metadata = new RequestMatcherMetadataResponseResolver(registrations, (Saml2MetadataResolver)new OpenSamlMetadataResolver());
            metadata.setRequestMatcher((RequestMatcher)new AntPathRequestMatcher(metadataUrl));
            return metadata;
        };
        return this;
    }

    public Saml2MetadataConfigurer<H> metadataResponseResolver(Saml2MetadataResponseResolver metadataResponseResolver) {
        Assert.notNull((Object)metadataResponseResolver, "metadataResponseResolver cannot be null");
        this.metadataResponseResolver = registrations -> metadataResponseResolver;
        return this;
    }

    @Override
    public H and() {
        return (H)((HttpSecurityBuilder)this.getBuilder());
    }

    @Override
    public void configure(H http) throws Exception {
        Saml2MetadataResponseResolver metadataResponseResolver = this.createMetadataResponseResolver(http);
        http.addFilterBefore((Filter)new Saml2MetadataFilter(metadataResponseResolver), BasicAuthenticationFilter.class);
    }

    private Saml2MetadataResponseResolver createMetadataResponseResolver(H http) {
        if (this.metadataResponseResolver != null) {
            RelyingPartyRegistrationRepository registrations = this.getRelyingPartyRegistrationRepository(http);
            return this.metadataResponseResolver.apply(registrations);
        }
        Saml2MetadataResponseResolver metadataResponseResolver = this.getBeanOrNull(Saml2MetadataResponseResolver.class);
        if (metadataResponseResolver != null) {
            return metadataResponseResolver;
        }
        RelyingPartyRegistrationRepository registrations = this.getRelyingPartyRegistrationRepository(http);
        return new RequestMatcherMetadataResponseResolver(registrations, (Saml2MetadataResolver)new OpenSamlMetadataResolver());
    }

    private RelyingPartyRegistrationRepository getRelyingPartyRegistrationRepository(H http) {
        Saml2LoginConfigurer login = http.getConfigurer(Saml2LoginConfigurer.class);
        if (login != null) {
            return login.relyingPartyRegistrationRepository(http);
        }
        return this.getBeanOrNull(RelyingPartyRegistrationRepository.class);
    }

    private <C> C getBeanOrNull(Class<C> clazz) {
        if (this.context == null) {
            return null;
        }
        if (this.context.getBeanNamesForType(clazz).length == 0) {
            return null;
        }
        return this.context.getBean(clazz);
    }
}

