/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.core.ResolvableType;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutConfigurer;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.session.AbstractSessionEvent;
import org.springframework.security.core.session.SessionDestroyedEvent;
import org.springframework.security.core.session.SessionIdChangedEvent;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationProvider;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.oidc.session.InMemoryOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionInformation;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class OAuth2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractAuthenticationFilterConfigurer<B, OAuth2LoginConfigurer<B>, OAuth2LoginAuthenticationFilter> {
    private final AuthorizationEndpointConfig authorizationEndpointConfig = new AuthorizationEndpointConfig();
    private final TokenEndpointConfig tokenEndpointConfig = new TokenEndpointConfig();
    private final RedirectionEndpointConfig redirectionEndpointConfig = new RedirectionEndpointConfig();
    private final UserInfoEndpointConfig userInfoEndpointConfig = new UserInfoEndpointConfig();
    private String loginPage;
    private String loginProcessingUrl = "/login/oauth2/code/*";

    public OAuth2LoginConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    public OAuth2LoginConfigurer<B> authorizedClientRepository(OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)authorizedClientRepository, "authorizedClientRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizedClientRepository.class, authorizedClientRepository);
        return this;
    }

    public OAuth2LoginConfigurer<B> authorizedClientService(OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, "authorizedClientService cannot be null");
        this.authorizedClientRepository((OAuth2AuthorizedClientRepository)new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService));
        return this;
    }

    @Override
    public OAuth2LoginConfigurer<B> loginPage(String loginPage) {
        Assert.hasText(loginPage, "loginPage cannot be empty");
        this.loginPage = loginPage;
        return this;
    }

    @Override
    public OAuth2LoginConfigurer<B> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText(loginProcessingUrl, "loginProcessingUrl cannot be empty");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    public OAuth2LoginConfigurer<B> oidcSessionRegistry(OidcSessionRegistry oidcSessionRegistry) {
        Assert.notNull((Object)oidcSessionRegistry, "oidcSessionRegistry cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OidcSessionRegistry.class, oidcSessionRegistry);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public AuthorizationEndpointConfig authorizationEndpoint() {
        return this.authorizationEndpointConfig;
    }

    public OAuth2LoginConfigurer<B> authorizationEndpoint(Customizer<AuthorizationEndpointConfig> authorizationEndpointCustomizer) {
        authorizationEndpointCustomizer.customize(this.authorizationEndpointConfig);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public TokenEndpointConfig tokenEndpoint() {
        return this.tokenEndpointConfig;
    }

    public OAuth2LoginConfigurer<B> tokenEndpoint(Customizer<TokenEndpointConfig> tokenEndpointCustomizer) {
        tokenEndpointCustomizer.customize(this.tokenEndpointConfig);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public RedirectionEndpointConfig redirectionEndpoint() {
        return this.redirectionEndpointConfig;
    }

    public OAuth2LoginConfigurer<B> redirectionEndpoint(Customizer<RedirectionEndpointConfig> redirectionEndpointCustomizer) {
        redirectionEndpointCustomizer.customize(this.redirectionEndpointConfig);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public UserInfoEndpointConfig userInfoEndpoint() {
        return this.userInfoEndpointConfig;
    }

    public OAuth2LoginConfigurer<B> userInfoEndpoint(Customizer<UserInfoEndpointConfig> userInfoEndpointCustomizer) {
        userInfoEndpointCustomizer.customize(this.userInfoEndpointConfig);
        return this;
    }

    @Override
    public void init(B http) throws Exception {
        OAuth2LoginAuthenticationFilter authenticationFilter = new OAuth2LoginAuthenticationFilter(OAuth2ClientConfigurerUtils.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()), OAuth2ClientConfigurerUtils.getAuthorizedClientRepository((HttpSecurityBuilder)this.getBuilder()), this.loginProcessingUrl);
        authenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        this.setAuthenticationFilter(authenticationFilter);
        super.loginProcessingUrl(this.loginProcessingUrl);
        if (this.loginPage != null) {
            super.loginPage(this.loginPage);
            super.init(http);
        } else {
            Map<String, String> loginUrlToClientName = this.getLoginLinks();
            if (loginUrlToClientName.size() == 1) {
                this.updateAuthenticationDefaults();
                this.updateAccessDefaults(http);
                String providerLoginPage = loginUrlToClientName.keySet().iterator().next();
                this.registerAuthenticationEntryPoint(http, this.getLoginEntryPoint(http, providerLoginPage));
            } else {
                super.init(http);
            }
        }
        OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient = this.getAccessTokenResponseClient();
        OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService = this.getOAuth2UserService();
        OAuth2LoginAuthenticationProvider oauth2LoginAuthenticationProvider = new OAuth2LoginAuthenticationProvider(accessTokenResponseClient, oauth2UserService);
        GrantedAuthoritiesMapper userAuthoritiesMapper = this.getGrantedAuthoritiesMapper();
        if (userAuthoritiesMapper != null) {
            oauth2LoginAuthenticationProvider.setAuthoritiesMapper(userAuthoritiesMapper);
        }
        http.authenticationProvider((AuthenticationProvider)this.postProcess(oauth2LoginAuthenticationProvider));
        boolean oidcAuthenticationProviderEnabled = ClassUtils.isPresent("org.springframework.security.oauth2.jwt.JwtDecoder", this.getClass().getClassLoader());
        if (oidcAuthenticationProviderEnabled) {
            OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService = this.getOidcUserService();
            OidcAuthorizationCodeAuthenticationProvider oidcAuthorizationCodeAuthenticationProvider = new OidcAuthorizationCodeAuthenticationProvider(accessTokenResponseClient, oidcUserService);
            JwtDecoderFactory<ClientRegistration> jwtDecoderFactory = this.getJwtDecoderFactoryBean();
            if (jwtDecoderFactory != null) {
                oidcAuthorizationCodeAuthenticationProvider.setJwtDecoderFactory(jwtDecoderFactory);
            }
            if (userAuthoritiesMapper != null) {
                oidcAuthorizationCodeAuthenticationProvider.setAuthoritiesMapper(userAuthoritiesMapper);
            }
            http.authenticationProvider((AuthenticationProvider)this.postProcess(oidcAuthorizationCodeAuthenticationProvider));
        } else {
            http.authenticationProvider(new OidcAuthenticationRequestChecker());
        }
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(B http) throws Exception {
        RequestCache requestCache;
        OAuth2AuthorizationRequestRedirectFilter authorizationRequestFilter;
        if (this.authorizationEndpointConfig.authorizationRequestResolver != null) {
            authorizationRequestFilter = new OAuth2AuthorizationRequestRedirectFilter(this.authorizationEndpointConfig.authorizationRequestResolver);
        } else {
            String authorizationRequestBaseUri = this.authorizationEndpointConfig.authorizationRequestBaseUri;
            if (authorizationRequestBaseUri == null) {
                authorizationRequestBaseUri = "/oauth2/authorization";
            }
            authorizationRequestFilter = new OAuth2AuthorizationRequestRedirectFilter(OAuth2ClientConfigurerUtils.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()), authorizationRequestBaseUri);
        }
        if (this.authorizationEndpointConfig.authorizationRequestRepository != null) {
            authorizationRequestFilter.setAuthorizationRequestRepository(this.authorizationEndpointConfig.authorizationRequestRepository);
        }
        if (this.authorizationEndpointConfig.authorizationRedirectStrategy != null) {
            authorizationRequestFilter.setAuthorizationRedirectStrategy(this.authorizationEndpointConfig.authorizationRedirectStrategy);
        }
        if ((requestCache = http.getSharedObject(RequestCache.class)) != null) {
            authorizationRequestFilter.setRequestCache(requestCache);
        }
        http.addFilter((Filter)this.postProcess(authorizationRequestFilter));
        OAuth2LoginAuthenticationFilter authenticationFilter = (OAuth2LoginAuthenticationFilter)this.getAuthenticationFilter();
        if (this.redirectionEndpointConfig.authorizationResponseBaseUri != null) {
            authenticationFilter.setFilterProcessesUrl(this.redirectionEndpointConfig.authorizationResponseBaseUri);
        }
        if (this.authorizationEndpointConfig.authorizationRequestRepository != null) {
            authenticationFilter.setAuthorizationRequestRepository(this.authorizationEndpointConfig.authorizationRequestRepository);
        }
        this.configureOidcSessionRegistry(http);
        super.configure(http);
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    private JwtDecoderFactory<ClientRegistration> getJwtDecoderFactoryBean() {
        ResolvableType type = ResolvableType.forClassWithGenerics(JwtDecoderFactory.class, ClientRegistration.class);
        String[] names = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class).getBeanNamesForType(type);
        if (names.length > 1) {
            throw new NoUniqueBeanDefinitionException(type, names);
        }
        if (names.length == 1) {
            return (JwtDecoderFactory)((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class).getBean(names[0]);
        }
        return null;
    }

    private GrantedAuthoritiesMapper getGrantedAuthoritiesMapper() {
        GrantedAuthoritiesMapper grantedAuthoritiesMapper = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(GrantedAuthoritiesMapper.class);
        if (grantedAuthoritiesMapper == null && (grantedAuthoritiesMapper = this.getGrantedAuthoritiesMapperBean()) != null) {
            ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(GrantedAuthoritiesMapper.class, grantedAuthoritiesMapper);
        }
        return grantedAuthoritiesMapper;
    }

    private GrantedAuthoritiesMapper getGrantedAuthoritiesMapperBean() {
        Map<String, GrantedAuthoritiesMapper> grantedAuthoritiesMapperMap = BeanFactoryUtils.beansOfTypeIncludingAncestors(((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class), GrantedAuthoritiesMapper.class);
        return !grantedAuthoritiesMapperMap.isEmpty() ? grantedAuthoritiesMapperMap.values().iterator().next() : null;
    }

    private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> getAccessTokenResponseClient() {
        if (this.tokenEndpointConfig.accessTokenResponseClient != null) {
            return this.tokenEndpointConfig.accessTokenResponseClient;
        }
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, OAuth2AuthorizationCodeGrantRequest.class);
        OAuth2AccessTokenResponseClient bean2 = (OAuth2AccessTokenResponseClient)this.getBeanOrNull(resolvableType);
        return bean2 != null ? bean2 : new DefaultAuthorizationCodeTokenResponseClient();
    }

    private OAuth2UserService<OidcUserRequest, OidcUser> getOidcUserService() {
        if (this.userInfoEndpointConfig.oidcUserService != null) {
            return this.userInfoEndpointConfig.oidcUserService;
        }
        ResolvableType type = ResolvableType.forClassWithGenerics(OAuth2UserService.class, OidcUserRequest.class, OidcUser.class);
        OAuth2UserService bean2 = (OAuth2UserService)this.getBeanOrNull(type);
        return bean2 != null ? bean2 : new OidcUserService();
    }

    private OAuth2UserService<OAuth2UserRequest, OAuth2User> getOAuth2UserService() {
        if (this.userInfoEndpointConfig.userService != null) {
            return this.userInfoEndpointConfig.userService;
        }
        ResolvableType type = ResolvableType.forClassWithGenerics(OAuth2UserService.class, OAuth2UserRequest.class, OAuth2User.class);
        OAuth2UserService bean2 = (OAuth2UserService)this.getBeanOrNull(type);
        return bean2 != null ? bean2 : new DefaultOAuth2UserService();
    }

    private <T> T getBeanOrNull(ResolvableType type) {
        String[] names;
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context != null && (names = context.getBeanNamesForType(type)).length == 1) {
            return (T)context.getBean(names[0]);
        }
        return null;
    }

    private void initDefaultLoginFilter(B http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setOauth2LoginEnabled(true);
        loginPageGeneratingFilter.setOauth2AuthenticationUrlToClientName(this.getLoginLinks());
        loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
        loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
    }

    private Map<String, String> getLoginLinks() {
        Iterable clientRegistrations = null;
        ClientRegistrationRepository clientRegistrationRepository = OAuth2ClientConfigurerUtils.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder());
        ResolvableType type = ResolvableType.forInstance(clientRegistrationRepository).as(Iterable.class);
        if (type != ResolvableType.NONE && ClientRegistration.class.isAssignableFrom(type.resolveGenerics()[0])) {
            clientRegistrations = (Iterable)clientRegistrationRepository;
        }
        if (clientRegistrations == null) {
            return Collections.emptyMap();
        }
        String authorizationRequestBaseUri = this.authorizationEndpointConfig.authorizationRequestBaseUri != null ? this.authorizationEndpointConfig.authorizationRequestBaseUri : "/oauth2/authorization";
        HashMap<String, String> loginUrlToClientName = new HashMap<String, String>();
        clientRegistrations.forEach(registration -> {
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)registration.getAuthorizationGrantType())) {
                String authorizationRequestUri = authorizationRequestBaseUri + "/" + registration.getRegistrationId();
                loginUrlToClientName.put(authorizationRequestUri, registration.getClientName());
            }
        });
        return loginUrlToClientName;
    }

    private AuthenticationEntryPoint getLoginEntryPoint(B http, String providerLoginPage) {
        AntPathRequestMatcher loginPageMatcher = new AntPathRequestMatcher(this.getLoginPage());
        AntPathRequestMatcher faviconMatcher = new AntPathRequestMatcher("/favicon.ico");
        RequestMatcher defaultEntryPointMatcher = this.getAuthenticationEntryPointMatcher(http);
        AndRequestMatcher defaultLoginPageMatcher = new AndRequestMatcher(new OrRequestMatcher(loginPageMatcher, faviconMatcher), defaultEntryPointMatcher);
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher(new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        RequestMatcher formLoginNotEnabled = this.getFormLoginNotEnabledRequestMatcher(http);
        LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints = new LinkedHashMap<RequestMatcher, AuthenticationEntryPoint>();
        entryPoints.put(new AndRequestMatcher(notXRequestedWith, new NegatedRequestMatcher(defaultLoginPageMatcher), formLoginNotEnabled), new LoginUrlAuthenticationEntryPoint(providerLoginPage));
        DelegatingAuthenticationEntryPoint loginEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        loginEntryPoint.setDefaultEntryPoint(this.getAuthenticationEntryPoint());
        return loginEntryPoint;
    }

    private RequestMatcher getFormLoginNotEnabledRequestMatcher(B http) {
        Field formLoginEnabledField;
        DefaultLoginPageGeneratingFilter defaultLoginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        Field field = formLoginEnabledField = defaultLoginPageGeneratingFilter != null ? ReflectionUtils.findField(DefaultLoginPageGeneratingFilter.class, "formLoginEnabled") : null;
        if (formLoginEnabledField != null) {
            ReflectionUtils.makeAccessible(formLoginEnabledField);
            return request -> Boolean.FALSE.equals(ReflectionUtils.getField(formLoginEnabledField, defaultLoginPageGeneratingFilter));
        }
        return AnyRequestMatcher.INSTANCE;
    }

    private void configureOidcSessionRegistry(B http) {
        if (http.getConfigurer(OidcLogoutConfigurer.class) == null && http.getSharedObject(OidcSessionRegistry.class) == null) {
            return;
        }
        OidcSessionRegistry sessionRegistry = OAuth2ClientConfigurerUtils.getOidcSessionRegistry(http);
        SessionManagementConfigurer sessionConfigurer = http.getConfigurer(SessionManagementConfigurer.class);
        if (sessionConfigurer != null) {
            OidcSessionRegistryAuthenticationStrategy sessionAuthenticationStrategy = new OidcSessionRegistryAuthenticationStrategy();
            sessionAuthenticationStrategy.setSessionRegistry(sessionRegistry);
            sessionConfigurer.addSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        }
        OidcClientSessionEventListener listener = new OidcClientSessionEventListener();
        listener.setSessionRegistry(sessionRegistry);
        this.registerDelegateApplicationListener(listener);
    }

    private void registerDelegateApplicationListener(ApplicationListener<?> delegate) {
        DelegatingApplicationListener delegating = (DelegatingApplicationListener)this.getBeanOrNull(ResolvableType.forType(DelegatingApplicationListener.class));
        if (delegating == null) {
            return;
        }
        GenericApplicationListenerAdapter smartListener = new GenericApplicationListenerAdapter(delegate);
        delegating.addListener(smartListener);
    }

    public final class AuthorizationEndpointConfig {
        private String authorizationRequestBaseUri;
        private OAuth2AuthorizationRequestResolver authorizationRequestResolver;
        private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;
        private RedirectStrategy authorizationRedirectStrategy;

        private AuthorizationEndpointConfig() {
        }

        public AuthorizationEndpointConfig baseUri(String authorizationRequestBaseUri) {
            Assert.hasText(authorizationRequestBaseUri, "authorizationRequestBaseUri cannot be empty");
            this.authorizationRequestBaseUri = authorizationRequestBaseUri;
            return this;
        }

        public AuthorizationEndpointConfig authorizationRequestResolver(OAuth2AuthorizationRequestResolver authorizationRequestResolver) {
            Assert.notNull((Object)authorizationRequestResolver, "authorizationRequestResolver cannot be null");
            this.authorizationRequestResolver = authorizationRequestResolver;
            return this;
        }

        public AuthorizationEndpointConfig authorizationRequestRepository(AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
            Assert.notNull(authorizationRequestRepository, "authorizationRequestRepository cannot be null");
            this.authorizationRequestRepository = authorizationRequestRepository;
            return this;
        }

        public AuthorizationEndpointConfig authorizationRedirectStrategy(RedirectStrategy authorizationRedirectStrategy) {
            this.authorizationRedirectStrategy = authorizationRedirectStrategy;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public OAuth2LoginConfigurer<B> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    public final class TokenEndpointConfig {
        private OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;

        private TokenEndpointConfig() {
        }

        public TokenEndpointConfig accessTokenResponseClient(OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
            Assert.notNull(accessTokenResponseClient, "accessTokenResponseClient cannot be null");
            this.accessTokenResponseClient = accessTokenResponseClient;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public OAuth2LoginConfigurer<B> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    public final class RedirectionEndpointConfig {
        private String authorizationResponseBaseUri;

        private RedirectionEndpointConfig() {
        }

        public RedirectionEndpointConfig baseUri(String authorizationResponseBaseUri) {
            Assert.hasText(authorizationResponseBaseUri, "authorizationResponseBaseUri cannot be empty");
            this.authorizationResponseBaseUri = authorizationResponseBaseUri;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public OAuth2LoginConfigurer<B> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    public final class UserInfoEndpointConfig {
        private OAuth2UserService<OAuth2UserRequest, OAuth2User> userService;
        private OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService;

        private UserInfoEndpointConfig() {
        }

        public UserInfoEndpointConfig userService(OAuth2UserService<OAuth2UserRequest, OAuth2User> userService) {
            Assert.notNull(userService, "userService cannot be null");
            this.userService = userService;
            return this;
        }

        public UserInfoEndpointConfig oidcUserService(OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService) {
            Assert.notNull(oidcUserService, "oidcUserService cannot be null");
            this.oidcUserService = oidcUserService;
            return this;
        }

        public UserInfoEndpointConfig userAuthoritiesMapper(GrantedAuthoritiesMapper userAuthoritiesMapper) {
            Assert.notNull((Object)userAuthoritiesMapper, "userAuthoritiesMapper cannot be null");
            ((HttpSecurityBuilder)OAuth2LoginConfigurer.this.getBuilder()).setSharedObject(GrantedAuthoritiesMapper.class, userAuthoritiesMapper);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public OAuth2LoginConfigurer<B> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    private static class OidcAuthenticationRequestChecker
    implements AuthenticationProvider {
        private OidcAuthenticationRequestChecker() {
        }

        @Override
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            OAuth2LoginAuthenticationToken authorizationCodeAuthentication = (OAuth2LoginAuthenticationToken)authentication;
            OAuth2AuthorizationRequest authorizationRequest = authorizationCodeAuthentication.getAuthorizationExchange().getAuthorizationRequest();
            if (authorizationRequest.getScopes().contains("openid")) {
                OAuth2Error oauth2Error = new OAuth2Error("oidc_provider_not_configured", "An OpenID Connect Authentication Provider has not been configured. Check to ensure you include the dependency 'spring-security-oauth2-jose'.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            return null;
        }

        @Override
        public boolean supports(Class<?> authentication) {
            return OAuth2LoginAuthenticationToken.class.isAssignableFrom(authentication);
        }
    }

    private static final class OidcSessionRegistryAuthenticationStrategy
    implements SessionAuthenticationStrategy {
        private final Log logger = LogFactory.getLog(this.getClass());
        private OidcSessionRegistry sessionRegistry = new InMemoryOidcSessionRegistry();

        private OidcSessionRegistryAuthenticationStrategy() {
        }

        @Override
        public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return;
            }
            Object object = authentication.getPrincipal();
            if (!(object instanceof OidcUser)) {
                return;
            }
            OidcUser user = (OidcUser)object;
            String sessionId = session.getId();
            CsrfToken csrfToken = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
            Map headers = csrfToken != null ? Map.of(csrfToken.getHeaderName(), csrfToken.getToken()) : Collections.emptyMap();
            OidcSessionInformation registration = new OidcSessionInformation(sessionId, headers, user);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(String.format("Linking a provider [%s] session to this client's session", user.getIssuer()));
            }
            this.sessionRegistry.saveSessionInformation(registration);
        }

        void setSessionRegistry(OidcSessionRegistry sessionRegistry) {
            Assert.notNull((Object)sessionRegistry, "sessionRegistry cannot be null");
            this.sessionRegistry = sessionRegistry;
        }
    }

    private static final class OidcClientSessionEventListener
    implements ApplicationListener<AbstractSessionEvent> {
        private final Log logger = LogFactory.getLog(OidcClientSessionEventListener.class);
        private OidcSessionRegistry sessionRegistry = new InMemoryOidcSessionRegistry();

        private OidcClientSessionEventListener() {
        }

        @Override
        public void onApplicationEvent(AbstractSessionEvent event) {
            if (event instanceof SessionDestroyedEvent) {
                SessionDestroyedEvent destroyed = (SessionDestroyedEvent)event;
                this.logger.debug("Received SessionDestroyedEvent");
                this.sessionRegistry.removeSessionInformation(destroyed.getId());
                return;
            }
            if (event instanceof SessionIdChangedEvent) {
                SessionIdChangedEvent changed = (SessionIdChangedEvent)event;
                this.logger.debug("Received SessionIdChangedEvent");
                OidcSessionInformation information = this.sessionRegistry.removeSessionInformation(changed.getOldSessionId());
                if (information == null) {
                    this.logger.debug("Failed to register new session id since old session id was not found in registry");
                    return;
                }
                this.sessionRegistry.saveSessionInformation(information.withSessionId(changed.getNewSessionId()));
            }
        }

        void setSessionRegistry(OidcSessionRegistry sessionRegistry) {
            Assert.notNull((Object)sessionRegistry, "sessionRegistry cannot be null");
            this.sessionRegistry = sessionRegistry;
        }
    }
}

