/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.CompositeAccessDeniedHandler;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.access.ObservationMarkingAccessDeniedHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.security.web.session.InvalidSessionAccessDeniedHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class CsrfConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<CsrfConfigurer<H>, H> {
    private CsrfTokenRepository csrfTokenRepository = new HttpSessionCsrfTokenRepository();
    private RequestMatcher requireCsrfProtectionMatcher = CsrfFilter.DEFAULT_CSRF_MATCHER;
    private List<RequestMatcher> ignoredCsrfProtectionMatchers = new ArrayList<RequestMatcher>();
    private SessionAuthenticationStrategy sessionAuthenticationStrategy;
    private CsrfTokenRequestHandler requestHandler;
    private final ApplicationContext context;

    public CsrfConfigurer(ApplicationContext context) {
        this.context = context;
    }

    public CsrfConfigurer<H> csrfTokenRepository(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, "csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
        return this;
    }

    public CsrfConfigurer<H> requireCsrfProtectionMatcher(RequestMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)requireCsrfProtectionMatcher, "requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
        return this;
    }

    public CsrfConfigurer<H> csrfTokenRequestHandler(CsrfTokenRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
        return this;
    }

    public CsrfConfigurer<H> ignoringRequestMatchers(RequestMatcher ... requestMatchers) {
        return ((IgnoreCsrfProtectionRegistry)new IgnoreCsrfProtectionRegistry(this.context).requestMatchers(requestMatchers)).and();
    }

    public CsrfConfigurer<H> ignoringRequestMatchers(String ... patterns) {
        return ((IgnoreCsrfProtectionRegistry)new IgnoreCsrfProtectionRegistry(this.context).requestMatchers(patterns)).and();
    }

    public CsrfConfigurer<H> sessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        Assert.notNull((Object)sessionAuthenticationStrategy, "sessionAuthenticationStrategy cannot be null");
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
        return this;
    }

    @Override
    public void configure(H http) {
        SessionManagementConfigurer sessionConfigurer;
        LogoutConfigurer logoutConfigurer;
        CsrfFilter filter2 = new CsrfFilter(this.csrfTokenRepository);
        RequestMatcher requireCsrfProtectionMatcher = this.getRequireCsrfProtectionMatcher();
        if (requireCsrfProtectionMatcher != null) {
            filter2.setRequireCsrfProtectionMatcher(requireCsrfProtectionMatcher);
        }
        AccessDeniedHandler accessDeniedHandler = this.createAccessDeniedHandler(http);
        ObservationRegistry registry = this.getObservationRegistry();
        if (!registry.isNoop()) {
            ObservationMarkingAccessDeniedHandler observable = new ObservationMarkingAccessDeniedHandler(registry);
            accessDeniedHandler = new CompositeAccessDeniedHandler(observable, accessDeniedHandler);
        }
        if (accessDeniedHandler != null) {
            filter2.setAccessDeniedHandler(accessDeniedHandler);
        }
        if ((logoutConfigurer = http.getConfigurer(LogoutConfigurer.class)) != null) {
            logoutConfigurer.addLogoutHandler(new CsrfLogoutHandler(this.csrfTokenRepository));
        }
        if ((sessionConfigurer = http.getConfigurer(SessionManagementConfigurer.class)) != null) {
            sessionConfigurer.addSessionAuthenticationStrategy(this.getSessionAuthenticationStrategy());
        }
        if (this.requestHandler != null) {
            filter2.setRequestHandler(this.requestHandler);
        }
        filter2 = this.postProcess(filter2);
        http.addFilter(filter2);
    }

    private RequestMatcher getRequireCsrfProtectionMatcher() {
        if (this.ignoredCsrfProtectionMatchers.isEmpty()) {
            return this.requireCsrfProtectionMatcher;
        }
        return new AndRequestMatcher(this.requireCsrfProtectionMatcher, new NegatedRequestMatcher(new OrRequestMatcher(this.ignoredCsrfProtectionMatchers)));
    }

    private AccessDeniedHandler getDefaultAccessDeniedHandler(H http) {
        ExceptionHandlingConfigurer exceptionConfig = http.getConfigurer(ExceptionHandlingConfigurer.class);
        AccessDeniedHandler handler = null;
        if (exceptionConfig != null) {
            handler = exceptionConfig.getAccessDeniedHandler(http);
        }
        if (handler == null) {
            handler = new AccessDeniedHandlerImpl();
        }
        return handler;
    }

    private InvalidSessionStrategy getInvalidSessionStrategy(H http) {
        SessionManagementConfigurer sessionManagement = http.getConfigurer(SessionManagementConfigurer.class);
        if (sessionManagement == null) {
            return null;
        }
        return sessionManagement.getInvalidSessionStrategy();
    }

    private AccessDeniedHandler createAccessDeniedHandler(H http) {
        InvalidSessionStrategy invalidSessionStrategy = this.getInvalidSessionStrategy(http);
        AccessDeniedHandler defaultAccessDeniedHandler = this.getDefaultAccessDeniedHandler(http);
        if (invalidSessionStrategy == null) {
            return defaultAccessDeniedHandler;
        }
        InvalidSessionAccessDeniedHandler invalidSessionDeniedHandler = new InvalidSessionAccessDeniedHandler(invalidSessionStrategy);
        LinkedHashMap<Class<? extends AccessDeniedException>, AccessDeniedHandler> handlers = new LinkedHashMap<Class<? extends AccessDeniedException>, AccessDeniedHandler>();
        handlers.put(MissingCsrfTokenException.class, invalidSessionDeniedHandler);
        return new DelegatingAccessDeniedHandler(handlers, defaultAccessDeniedHandler);
    }

    private SessionAuthenticationStrategy getSessionAuthenticationStrategy() {
        if (this.sessionAuthenticationStrategy != null) {
            return this.sessionAuthenticationStrategy;
        }
        CsrfAuthenticationStrategy csrfAuthenticationStrategy = new CsrfAuthenticationStrategy(this.csrfTokenRepository);
        if (this.requestHandler != null) {
            csrfAuthenticationStrategy.setRequestHandler(this.requestHandler);
        }
        return csrfAuthenticationStrategy;
    }

    private ObservationRegistry getObservationRegistry() {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(ObservationRegistry.class);
        if (names.length == 1) {
            return context.getBean(ObservationRegistry.class);
        }
        return ObservationRegistry.NOOP;
    }

    private class IgnoreCsrfProtectionRegistry
    extends AbstractRequestMatcherRegistry<IgnoreCsrfProtectionRegistry> {
        IgnoreCsrfProtectionRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        CsrfConfigurer<H> and() {
            return CsrfConfigurer.this;
        }

        @Override
        protected IgnoreCsrfProtectionRegistry chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            CsrfConfigurer.this.ignoredCsrfProtectionMatchers.addAll(requestMatchers);
            return this;
        }
    }
}

