/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.authorization.SpringAuthorizationEventPublisher;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcherEntry;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

public final class AuthorizeHttpRequestsConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<AuthorizeHttpRequestsConfigurer<H>, H> {
    static final AuthorizationManager<RequestAuthorizationContext> permitAllAuthorizationManager = (a, o) -> new AuthorizationDecision(true);
    private final AuthorizationManagerRequestMatcherRegistry registry;
    private final AuthorizationEventPublisher publisher;
    private final Supplier<RoleHierarchy> roleHierarchy;
    private String rolePrefix = "ROLE_";

    public AuthorizeHttpRequestsConfigurer(ApplicationContext context) {
        this.registry = new AuthorizationManagerRequestMatcherRegistry(context);
        this.publisher = context.getBeanNamesForType(AuthorizationEventPublisher.class).length > 0 ? context.getBean(AuthorizationEventPublisher.class) : new SpringAuthorizationEventPublisher(context);
        this.roleHierarchy = SingletonSupplier.of(() -> context.getBeanNamesForType(RoleHierarchy.class).length > 0 ? context.getBean(RoleHierarchy.class) : new NullRoleHierarchy());
        String[] grantedAuthorityDefaultsBeanNames = context.getBeanNamesForType(GrantedAuthorityDefaults.class);
        if (grantedAuthorityDefaultsBeanNames.length > 0) {
            GrantedAuthorityDefaults grantedAuthorityDefaults = context.getBean(GrantedAuthorityDefaults.class);
            this.rolePrefix = grantedAuthorityDefaults.getRolePrefix();
        }
    }

    public AuthorizationManagerRequestMatcherRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void configure(H http) {
        AuthorizationManager<HttpServletRequest> authorizationManager = this.registry.createAuthorizationManager();
        AuthorizationFilter authorizationFilter = new AuthorizationFilter(authorizationManager);
        authorizationFilter.setAuthorizationEventPublisher(this.publisher);
        authorizationFilter.setShouldFilterAllDispatcherTypes(this.registry.shouldFilterAllDispatcherTypes);
        authorizationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        http.addFilter(this.postProcess(authorizationFilter));
    }

    private AuthorizationManagerRequestMatcherRegistry addMapping(List<? extends RequestMatcher> matchers, AuthorizationManager<RequestAuthorizationContext> manager) {
        for (RequestMatcher requestMatcher : matchers) {
            this.registry.addMapping(requestMatcher, manager);
        }
        return this.registry;
    }

    AuthorizationManagerRequestMatcherRegistry addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
        this.registry.addFirst(matcher, manager);
        return this.registry;
    }

    private ObservationRegistry getObservationRegistry() {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        String[] names = context.getBeanNamesForType(ObservationRegistry.class);
        if (names.length == 1) {
            return context.getBean(ObservationRegistry.class);
        }
        return ObservationRegistry.NOOP;
    }

    public final class AuthorizationManagerRequestMatcherRegistry
    extends AbstractRequestMatcherRegistry<AuthorizedUrl> {
        private final RequestMatcherDelegatingAuthorizationManager.Builder managerBuilder = RequestMatcherDelegatingAuthorizationManager.builder();
        private List<RequestMatcher> unmappedMatchers;
        private int mappingCount;
        private boolean shouldFilterAllDispatcherTypes = true;

        private AuthorizationManagerRequestMatcherRegistry(ApplicationContext context) {
            this.setApplicationContext(context);
        }

        private void addMapping(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            this.unmappedMatchers = null;
            this.managerBuilder.add(matcher, manager);
            ++this.mappingCount;
        }

        private void addFirst(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            this.unmappedMatchers = null;
            this.managerBuilder.mappings(m4 -> m4.add(0, new RequestMatcherEntry<AuthorizationManager>(matcher, manager)));
            ++this.mappingCount;
        }

        private AuthorizationManager<HttpServletRequest> createAuthorizationManager() {
            Assert.state(this.unmappedMatchers == null, () -> "An incomplete mapping was found for " + this.unmappedMatchers + ". Try completing it with something like requestUrls().<something>.hasRole('USER')");
            Assert.state(this.mappingCount > 0, "At least one mapping is required (for example, authorizeHttpRequests().anyRequest().authenticated())");
            ObservationRegistry registry = AuthorizeHttpRequestsConfigurer.this.getObservationRegistry();
            RequestMatcherDelegatingAuthorizationManager manager = (RequestMatcherDelegatingAuthorizationManager)AuthorizeHttpRequestsConfigurer.this.postProcess(this.managerBuilder.build());
            if (registry.isNoop()) {
                return manager;
            }
            return new ObservationAuthorizationManager<HttpServletRequest>(registry, manager);
        }

        @Override
        protected AuthorizedUrl chainRequestMatchers(List<RequestMatcher> requestMatchers) {
            this.unmappedMatchers = requestMatchers;
            return new AuthorizedUrl(requestMatchers);
        }

        public AuthorizationManagerRequestMatcherRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            AuthorizeHttpRequestsConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public AuthorizationManagerRequestMatcherRegistry shouldFilterAllDispatcherTypes(boolean shouldFilter) {
            this.shouldFilterAllDispatcherTypes = shouldFilter;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public H and() {
            return (HttpSecurityBuilder)AuthorizeHttpRequestsConfigurer.this.and();
        }
    }

    public class AuthorizedUrl {
        private final List<? extends RequestMatcher> matchers;

        AuthorizedUrl(List<? extends RequestMatcher> matchers) {
            this.matchers = matchers;
        }

        protected List<? extends RequestMatcher> getMatchers() {
            return this.matchers;
        }

        public AuthorizationManagerRequestMatcherRegistry permitAll() {
            return this.access(permitAllAuthorizationManager);
        }

        public AuthorizationManagerRequestMatcherRegistry denyAll() {
            return this.access((a, o) -> new AuthorizationDecision(false));
        }

        public AuthorizationManagerRequestMatcherRegistry hasRole(String role) {
            return this.access(this.withRoleHierarchy(AuthorityAuthorizationManager.hasAnyRole(AuthorizeHttpRequestsConfigurer.this.rolePrefix, new String[]{role})));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyRole(String ... roles) {
            return this.access(this.withRoleHierarchy(AuthorityAuthorizationManager.hasAnyRole(AuthorizeHttpRequestsConfigurer.this.rolePrefix, roles)));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAuthority(String authority) {
            return this.access(this.withRoleHierarchy(AuthorityAuthorizationManager.hasAuthority(authority)));
        }

        public AuthorizationManagerRequestMatcherRegistry hasAnyAuthority(String ... authorities) {
            return this.access(this.withRoleHierarchy(AuthorityAuthorizationManager.hasAnyAuthority(authorities)));
        }

        private AuthorityAuthorizationManager<RequestAuthorizationContext> withRoleHierarchy(AuthorityAuthorizationManager<RequestAuthorizationContext> manager) {
            manager.setRoleHierarchy(AuthorizeHttpRequestsConfigurer.this.roleHierarchy.get());
            return manager;
        }

        public AuthorizationManagerRequestMatcherRegistry authenticated() {
            return this.access(AuthenticatedAuthorizationManager.authenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry fullyAuthenticated() {
            return this.access(AuthenticatedAuthorizationManager.fullyAuthenticated());
        }

        public AuthorizationManagerRequestMatcherRegistry rememberMe() {
            return this.access(AuthenticatedAuthorizationManager.rememberMe());
        }

        public AuthorizationManagerRequestMatcherRegistry anonymous() {
            return this.access(AuthenticatedAuthorizationManager.anonymous());
        }

        public AuthorizationManagerRequestMatcherRegistry access(AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.notNull(manager, "manager cannot be null");
            return AuthorizeHttpRequestsConfigurer.this.addMapping(this.matchers, manager);
        }
    }
}

