/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.DeferringObservationAuthorizationManager;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class Jsr250MethodSecurityConfiguration {
    Jsr250MethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor jsr250AuthorizationMethodInterceptor(ObjectProvider<GrantedAuthorityDefaults> defaultsProvider, ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<ObservationRegistry> registryProvider) {
        Jsr250AuthorizationManager jsr250 = new Jsr250AuthorizationManager();
        defaultsProvider.ifAvailable(d -> jsr250.setRolePrefix(d.getRolePrefix()));
        SecurityContextHolderStrategy strategy = strategyProvider.getIfAvailable(SecurityContextHolder::getContextHolderStrategy);
        DeferringObservationAuthorizationManager<MethodInvocation> manager = new DeferringObservationAuthorizationManager<MethodInvocation>(registryProvider, jsr250);
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.jsr250(manager);
        interceptor.setSecurityContextHolderStrategy(strategy);
        return interceptor;
    }
}

