/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.MethodClassKey;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationAnnotationUtils;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public final class SecuredAuthorizationManager
implements AuthorizationManager<MethodInvocation> {
    private AuthorizationManager<Collection<String>> authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
    private final Map<MethodClassKey, Set<String>> cachedAuthorities = new ConcurrentHashMap<MethodClassKey, Set<String>>();

    public void setAuthoritiesAuthorizationManager(AuthorizationManager<Collection<String>> authoritiesAuthorizationManager) {
        Assert.notNull(authoritiesAuthorizationManager, "authoritiesAuthorizationManager cannot be null");
        this.authoritiesAuthorizationManager = authoritiesAuthorizationManager;
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, MethodInvocation mi) {
        Set<String> authorities = this.getAuthorities(mi);
        return authorities.isEmpty() ? null : this.authoritiesAuthorizationManager.check(authentication, authorities);
    }

    private Set<String> getAuthorities(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Object target = methodInvocation.getThis();
        Class<?> targetClass = target != null ? target.getClass() : null;
        MethodClassKey cacheKey = new MethodClassKey(method, targetClass);
        return this.cachedAuthorities.computeIfAbsent(cacheKey, k -> this.resolveAuthorities(method, targetClass));
    }

    private Set<String> resolveAuthorities(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        Secured secured = this.findSecuredAnnotation(specificMethod);
        return secured != null ? Set.of(secured.value()) : Collections.emptySet();
    }

    private Secured findSecuredAnnotation(Method method) {
        Secured secured = AuthorizationAnnotationUtils.findUniqueAnnotation(method, Secured.class);
        return secured != null ? secured : AuthorizationAnnotationUtils.findUniqueAnnotation(method.getDeclaringClass(), Secured.class);
    }
}

