/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.PreAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.ReactiveAuthenticationUtils;
import org.springframework.security.authorization.method.ReactiveMethodInvocationUtils;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AuthorizationManagerBeforeReactiveMethodInterceptor
implements Ordered,
MethodInterceptor,
PointcutAdvisor,
AopInfrastructureBean {
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private static final int RETURN_TYPE_METHOD_PARAMETER_INDEX = -1;
    private final Pointcut pointcut;
    private final ReactiveAuthorizationManager<MethodInvocation> authorizationManager;
    private int order = AuthorizationInterceptorsOrder.FIRST.getOrder();

    public static AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorize() {
        return AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize(new PreAuthorizeReactiveAuthorizationManager());
    }

    public static AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorize(ReactiveAuthorizationManager<MethodInvocation> authorizationManager) {
        AuthorizationManagerBeforeReactiveMethodInterceptor interceptor = new AuthorizationManagerBeforeReactiveMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PreAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.PRE_AUTHORIZE.getOrder());
        return interceptor;
    }

    public AuthorizationManagerBeforeReactiveMethodInterceptor(Pointcut pointcut, ReactiveAuthorizationManager<MethodInvocation> authorizationManager) {
        Assert.notNull((Object)pointcut, "pointcut cannot be null");
        Assert.notNull(authorizationManager, "authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        Class<?> type = method.getReturnType();
        boolean isSuspendingFunction = KotlinDetector.isSuspendingFunction(method);
        boolean hasFlowReturnType = COROUTINES_FLOW_CLASS_NAME.equals(new MethodParameter(method, -1).getParameterType().getName());
        boolean hasReactiveReturnType = Publisher.class.isAssignableFrom(type) || isSuspendingFunction || hasFlowReturnType;
        Assert.state(hasReactiveReturnType, () -> "The returnType " + type + " on " + method + " must return an instance of org.reactivestreams.Publisher (for example, a Mono or Flux) or the function must be a Kotlin coroutine in order to support Reactor Context");
        Mono<Authentication> authentication = ReactiveAuthenticationUtils.getAuthentication();
        ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(type);
        Mono<Void> preAuthorize = this.authorizationManager.verify(authentication, mi);
        if (hasFlowReturnType) {
            if (isSuspendingFunction) {
                return preAuthorize.thenMany((Publisher)Flux.defer(() -> (Publisher)ReactiveMethodInvocationUtils.proceed(mi)));
            }
            Assert.state(adapter != null, () -> "The returnType " + type + " on " + method + " must have a org.springframework.core.ReactiveAdapter registered");
            Flux response = preAuthorize.thenMany((Publisher)Flux.defer(() -> adapter.toPublisher(ReactiveMethodInvocationUtils.proceed(mi))));
            return KotlinDelegate.asFlow(response);
        }
        if (this.isMultiValue(type, adapter)) {
            Flux publisher = Flux.defer(() -> (Publisher)ReactiveMethodInvocationUtils.proceed(mi));
            Flux result = preAuthorize.thenMany((Publisher)publisher);
            return adapter != null ? adapter.fromPublisher((Publisher<?>)result) : result;
        }
        Mono publisher = Mono.defer(() -> (Mono)ReactiveMethodInvocationUtils.proceed(mi));
        Mono result = preAuthorize.then(publisher);
        return adapter != null ? adapter.fromPublisher((Publisher<?>)result) : result;
    }

    private boolean isMultiValue(Class<?> returnType, ReactiveAdapter adapter) {
        if (Flux.class.isAssignableFrom(returnType)) {
            return true;
        }
        return adapter != null && adapter.isMultiValue();
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Override
    public Advice getAdvice() {
        return this;
    }

    @Override
    public boolean isPerInstance() {
        return true;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        private static Object asFlow(Publisher<?> publisher) {
            return ReactiveFlowKt.asFlow(publisher);
        }
    }
}

