/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.support.Netty5HeadersAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.netty5.ChannelOperationsId;
import reactor.netty5.Connection;
import reactor.netty5.NettyInbound;
import reactor.netty5.http.client.HttpClientResponse;

class ReactorNetty2ClientHttpResponse
implements ClientHttpResponse {
    private static final Log logger = LogFactory.getLog(ReactorNetty2ClientHttpResponse.class);
    private final HttpClientResponse response;
    private final HttpHeaders headers;
    private final NettyInbound inbound;
    private final Netty5DataBufferFactory bufferFactory;
    private final AtomicInteger state = new AtomicInteger();

    public ReactorNetty2ClientHttpResponse(HttpClientResponse response, Connection connection) {
        this.response = response;
        Netty5HeadersAdapter adapter = new Netty5HeadersAdapter(response.responseHeaders());
        this.headers = HttpHeaders.readOnlyHttpHeaders(adapter);
        this.inbound = connection.inbound();
        this.bufferFactory = new Netty5DataBufferFactory(connection.outbound().alloc());
    }

    @Override
    public String getId() {
        String id = null;
        HttpClientResponse httpClientResponse = this.response;
        if (httpClientResponse instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpClientResponse;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id == null && (httpClientResponse = this.response) instanceof Connection) {
            Connection connection = (Connection)httpClientResponse;
            id = connection.channel().id().asShortText();
        }
        return id != null ? id : ObjectUtils.getIdentityHexString(this);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.inbound.receive().doOnSubscribe(s2 -> {
            if (this.state.compareAndSet(0, 1)) {
                return;
            }
            if (this.state.get() == 2) {
                throw new IllegalStateException("The client response body has been released already due to cancellation.");
            }
        }).map(buffer -> this.bufferFactory.wrap(buffer.split()));
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.response.cookies().values().stream().flatMap(Collection::stream).forEach(cookie -> result.add(cookie.name().toString(), ResponseCookie.fromClientResponse(cookie.name().toString(), cookie.value().toString()).domain(cookie.domain() != null ? cookie.domain().toString() : null).path(cookie.path() != null ? cookie.path().toString() : null).maxAge(cookie.maxAge() != null ? cookie.maxAge() : -1L).secure(cookie.isSecure()).httpOnly(cookie.isHttpOnly()).sameSite(ReactorNetty2ClientHttpResponse.getSameSite(cookie)).build()));
        return CollectionUtils.unmodifiableMultiValueMap(result);
    }

    @Nullable
    private static String getSameSite(HttpSetCookie cookie) {
        DefaultHttpSetCookie defaultCookie;
        if (cookie instanceof DefaultHttpSetCookie && (defaultCookie = (DefaultHttpSetCookie)cookie).sameSite() != null) {
            return defaultCookie.sameSite().name();
        }
        return null;
    }

    void releaseAfterCancel(HttpMethod method) {
        if (this.mayHaveBody(method) && this.state.compareAndSet(0, 2)) {
            if (logger.isDebugEnabled()) {
                logger.debug("[" + this.getId() + "]Releasing body, not yet subscribed.");
            }
            this.inbound.receive().doOnNext(buffer -> {}).subscribe(buffer -> {}, ex -> {});
        }
    }

    private boolean mayHaveBody(HttpMethod method) {
        int code = this.getStatusCode().value();
        return (code < 100 || code >= 200) && code != 204 && code != 205 && !method.equals(HttpMethod.HEAD) && this.getHeaders().getContentLength() != 0L;
    }

    public String toString() {
        return "ReactorNetty2ClientHttpResponse{request=[" + this.response.method().name() + " " + this.response.uri() + "],status=" + this.getStatusCode() + "}";
    }
}

