/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public abstract class AbstractClientHttpResponse
implements ClientHttpResponse {
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final Flux<DataBuffer> body;

    protected AbstractClientHttpResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body2) {
        Assert.notNull((Object)statusCode, "StatusCode must not be null");
        Assert.notNull((Object)headers, "Headers must not be null");
        Assert.notNull(body2, "Body must not be null");
        this.statusCode = statusCode;
        this.headers = headers;
        this.cookies = cookies;
        this.body = AbstractClientHttpResponse.singleSubscription(body2);
    }

    private static Flux<DataBuffer> singleSubscription(Flux<DataBuffer> body2) {
        AtomicBoolean subscribed = new AtomicBoolean();
        return body2.doOnSubscribe(s2 -> {
            if (!subscribed.compareAndSet(false, true)) {
                throw new IllegalStateException("The client response body can only be consumed once");
            }
        });
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.body;
    }
}

