/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.init;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.sql.init.AbstractScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

public class DataSourceScriptDatabaseInitializer
extends AbstractScriptDatabaseInitializer {
    private static final Log logger = LogFactory.getLog(DataSourceScriptDatabaseInitializer.class);
    private final DataSource dataSource;

    public DataSourceScriptDatabaseInitializer(DataSource dataSource, DatabaseInitializationSettings settings) {
        super(settings);
        this.dataSource = dataSource;
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected boolean isEmbeddedDatabase() {
        try {
            return EmbeddedDatabaseConnection.isEmbedded(this.dataSource);
        }
        catch (Exception ex) {
            logger.debug("Could not determine if datasource is embedded", ex);
            return false;
        }
    }

    @Override
    protected void runScripts(AbstractScriptDatabaseInitializer.Scripts scripts) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(scripts.isContinueOnError());
        populator.setSeparator(scripts.getSeparator());
        if (scripts.getEncoding() != null) {
            populator.setSqlScriptEncoding(scripts.getEncoding().name());
        }
        for (Resource resource : scripts) {
            populator.addScript(resource);
        }
        this.customize(populator);
        DatabasePopulatorUtils.execute(populator, this.dataSource);
    }

    protected void customize(ResourceDatabasePopulator populator) {
    }
}

