/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.couchbase")
public class CouchbaseProperties {
    private String connectionString;
    private String username;
    private String password;
    private final Env env = new Env();

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Env getEnv() {
        return this.env;
    }

    public static class Env {
        private final Io io = new Io();
        private final Ssl ssl = new Ssl();
        private final Timeouts timeouts = new Timeouts();

        public Io getIo() {
            return this.io;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        public Timeouts getTimeouts() {
            return this.timeouts;
        }
    }

    public static class Timeouts {
        private Duration connect = Duration.ofSeconds(10L);
        private Duration disconnect = Duration.ofSeconds(10L);
        private Duration keyValue = Duration.ofMillis(2500L);
        private Duration keyValueDurable = Duration.ofSeconds(10L);
        private Duration query = Duration.ofSeconds(75L);
        private Duration view = Duration.ofSeconds(75L);
        private Duration search = Duration.ofSeconds(75L);
        private Duration analytics = Duration.ofSeconds(75L);
        private Duration management = Duration.ofSeconds(75L);

        public Duration getConnect() {
            return this.connect;
        }

        public void setConnect(Duration connect) {
            this.connect = connect;
        }

        public Duration getDisconnect() {
            return this.disconnect;
        }

        public void setDisconnect(Duration disconnect) {
            this.disconnect = disconnect;
        }

        public Duration getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(Duration keyValue) {
            this.keyValue = keyValue;
        }

        public Duration getKeyValueDurable() {
            return this.keyValueDurable;
        }

        public void setKeyValueDurable(Duration keyValueDurable) {
            this.keyValueDurable = keyValueDurable;
        }

        public Duration getQuery() {
            return this.query;
        }

        public void setQuery(Duration query2) {
            this.query = query2;
        }

        public Duration getView() {
            return this.view;
        }

        public void setView(Duration view) {
            this.view = view;
        }

        public Duration getSearch() {
            return this.search;
        }

        public void setSearch(Duration search) {
            this.search = search;
        }

        public Duration getAnalytics() {
            return this.analytics;
        }

        public void setAnalytics(Duration analytics) {
            this.analytics = analytics;
        }

        public Duration getManagement() {
            return this.management;
        }

        public void setManagement(Duration management) {
            this.management = management;
        }
    }

    public static class Ssl {
        private Boolean enabled;
        private String keyStore;
        private String keyStorePassword;
        private String bundle;

        public Boolean getEnabled() {
            return this.enabled != null ? this.enabled : StringUtils.hasText(this.keyStore) || StringUtils.hasText(this.bundle);
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Deprecated(since="3.1.0", forRemoval=true)
        @DeprecatedConfigurationProperty(reason="SSL bundle support with spring.ssl.bundle and spring.couchbase.env.ssl.bundle should be used instead", since="3.1.0")
        public String getKeyStore() {
            return this.keyStore;
        }

        @Deprecated(since="3.1.0", forRemoval=true)
        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Deprecated(since="3.1.0", forRemoval=true)
        @DeprecatedConfigurationProperty(reason="SSL bundle support with spring.ssl.bundle and spring.couchbase.env.ssl.bundle should be used instead", since="3.1.0")
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        @Deprecated(since="3.1.0", forRemoval=true)
        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getBundle() {
            return this.bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }
    }

    public static class Io {
        private int minEndpoints = 1;
        private int maxEndpoints = 12;
        private Duration idleHttpConnectionTimeout = Duration.ofSeconds(1L);

        public int getMinEndpoints() {
            return this.minEndpoints;
        }

        public void setMinEndpoints(int minEndpoints) {
            this.minEndpoints = minEndpoints;
        }

        public int getMaxEndpoints() {
            return this.maxEndpoints;
        }

        public void setMaxEndpoints(int maxEndpoints) {
            this.maxEndpoints = maxEndpoints;
        }

        public Duration getIdleHttpConnectionTimeout() {
            return this.idleHttpConnectionTimeout;
        }

        public void setIdleHttpConnectionTimeout(Duration idleHttpConnectionTimeout) {
            this.idleHttpConnectionTimeout = idleHttpConnectionTimeout;
        }
    }
}

