/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class SignatureUtils {
    public static String getSignatureString(Member m4, World world) {
        MemberKind kind = m4.getKind();
        if (kind == Member.METHOD) {
            return SignatureUtils.getMethodSignatureString(m4, world);
        }
        if (kind == Member.CONSTRUCTOR) {
            return SignatureUtils.getConstructorSignatureString(m4, world);
        }
        if (kind == Member.FIELD) {
            return SignatureUtils.getFieldSignatureString(m4, world);
        }
        if (kind == Member.HANDLER) {
            return SignatureUtils.getHandlerSignatureString(m4, world);
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return SignatureUtils.getStaticInitializationSignatureString(m4, world);
        }
        if (kind == Member.ADVICE) {
            return SignatureUtils.getAdviceSignatureString(m4, world);
        }
        if (kind == Member.MONITORENTER || kind == Member.MONITOREXIT) {
            return SignatureUtils.getMonitorSignatureString(m4, world);
        }
        throw new BCException("Do not know the signature string for MemberKind " + kind);
    }

    public static String getSignatureMakerName(Member m4) {
        MemberKind kind = m4.getKind();
        if (kind == Member.METHOD) {
            return "makeMethodSig";
        }
        if (kind == Member.CONSTRUCTOR) {
            return "makeConstructorSig";
        }
        if (kind == Member.FIELD) {
            return "makeFieldSig";
        }
        if (kind == Member.HANDLER) {
            return "makeCatchClauseSig";
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return "makeInitializerSig";
        }
        if (kind == Member.ADVICE) {
            return "makeAdviceSig";
        }
        if (kind == Member.MONITORENTER) {
            return "makeLockSig";
        }
        if (kind == Member.MONITOREXIT) {
            return "makeUnlockSig";
        }
        throw new BCException("Do not know the signature maker name for MemberKind " + kind);
    }

    public static String getSignatureType(Member m4) {
        MemberKind kind = m4.getKind();
        if (m4.getName().equals("<clinit>") && kind != Member.STATIC_INITIALIZATION) {
            throw new BCException();
        }
        if (kind == Member.METHOD) {
            return "org.aspectj.lang.reflect.MethodSignature";
        }
        if (kind == Member.CONSTRUCTOR) {
            return "org.aspectj.lang.reflect.ConstructorSignature";
        }
        if (kind == Member.FIELD) {
            return "org.aspectj.lang.reflect.FieldSignature";
        }
        if (kind == Member.HANDLER) {
            return "org.aspectj.lang.reflect.CatchClauseSignature";
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return "org.aspectj.lang.reflect.InitializerSignature";
        }
        if (kind == Member.ADVICE) {
            return "org.aspectj.lang.reflect.AdviceSignature";
        }
        if (kind == Member.MONITORENTER) {
            return "org.aspectj.lang.reflect.LockSignature";
        }
        if (kind == Member.MONITOREXIT) {
            return "org.aspectj.lang.reflect.UnlockSignature";
        }
        throw new BCException("Do not know the signature type for MemberKind " + kind);
    }

    private static String getHandlerSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(0));
        buf.append('-');
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterTypes()[0]));
        buf.append('-');
        String pName = "<missing>";
        String[] names = m4.getParameterNames(world);
        if (names != null) {
            pName = names[0];
        }
        buf.append(pName);
        buf.append('-');
        return buf.toString();
    }

    private static String getStaticInitializationSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m4.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String getAdviceSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m4.getModifiers(world)));
        buf.append('-');
        buf.append(m4.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterTypes()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterNames(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getExceptions(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String getMethodSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m4.getModifiers(world)));
        buf.append('-');
        buf.append(m4.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterTypes()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterNames(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getExceptions(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String getMonitorSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(8));
        buf.append('-');
        buf.append(m4.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterTypes()[0]));
        buf.append('-');
        buf.append("");
        buf.append('-');
        return buf.toString();
    }

    protected static String getConstructorSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m4.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterTypes()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getParameterNames(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getExceptions(world)));
        buf.append('-');
        return buf.toString();
    }

    protected static String getFieldSignatureString(Member m4, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m4.getModifiers(world)));
        buf.append('-');
        buf.append(m4.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m4.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String makeString(int i) {
        return Integer.toString(i, 16);
    }

    protected static String makeString(UnresolvedType t2) {
        if (t2.isArray()) {
            return t2.getSignature().replace('/', '.');
        }
        return t2.getName();
    }

    protected static String makeString(UnresolvedType[] types) {
        if (types == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            buf.append(SignatureUtils.makeString(types[i]));
            buf.append(':');
        }
        return buf.toString();
    }

    protected static String makeString(String[] names) {
        if (names == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            buf.append(names[i]);
            buf.append(':');
        }
        return buf.toString();
    }
}

