/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.Closeable;
import java.io.IOException;
import java.security.Principal;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;

public class DefaultKafkaPrincipalBuilder
implements KafkaPrincipalBuilder,
Closeable {
    private final PrincipalBuilder oldPrincipalBuilder;
    private final Authenticator authenticator;
    private final TransportLayer transportLayer;
    private final KerberosShortNamer kerberosShortNamer;

    public static DefaultKafkaPrincipalBuilder fromOldPrincipalBuilder(Authenticator authenticator, TransportLayer transportLayer, PrincipalBuilder oldPrincipalBuilder, KerberosShortNamer kerberosShortNamer) {
        return new DefaultKafkaPrincipalBuilder(Objects.requireNonNull(authenticator), Objects.requireNonNull(transportLayer), Objects.requireNonNull(oldPrincipalBuilder), kerberosShortNamer);
    }

    private DefaultKafkaPrincipalBuilder(Authenticator authenticator, TransportLayer transportLayer, PrincipalBuilder oldPrincipalBuilder, KerberosShortNamer kerberosShortNamer) {
        this.authenticator = authenticator;
        this.transportLayer = transportLayer;
        this.oldPrincipalBuilder = oldPrincipalBuilder;
        this.kerberosShortNamer = kerberosShortNamer;
    }

    public DefaultKafkaPrincipalBuilder(KerberosShortNamer kerberosShortNamer) {
        this(null, null, null, kerberosShortNamer);
    }

    @Override
    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof PlaintextAuthenticationContext) {
            if (this.oldPrincipalBuilder != null) {
                return this.convertToKafkaPrincipal(this.oldPrincipalBuilder.buildPrincipal(this.transportLayer, this.authenticator));
            }
            return KafkaPrincipal.ANONYMOUS;
        }
        if (context instanceof SslAuthenticationContext) {
            SSLSession sslSession = ((SslAuthenticationContext)context).session();
            if (this.oldPrincipalBuilder != null) {
                return this.convertToKafkaPrincipal(this.oldPrincipalBuilder.buildPrincipal(this.transportLayer, this.authenticator));
            }
            try {
                return this.convertToKafkaPrincipal(sslSession.getPeerPrincipal());
            }
            catch (SSLPeerUnverifiedException se) {
                return KafkaPrincipal.ANONYMOUS;
            }
        }
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            if ("GSSAPI".equals(saslServer.getMechanismName())) {
                return this.applyKerberosShortNamer(saslServer.getAuthorizationID());
            }
            return new KafkaPrincipal("User", saslServer.getAuthorizationID());
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    private KafkaPrincipal applyKerberosShortNamer(String authorizationId) {
        KerberosName kerberosName = KerberosName.parse(authorizationId);
        try {
            String shortName = this.kerberosShortNamer.shortName(kerberosName);
            return new KafkaPrincipal("User", shortName);
        }
        catch (IOException e) {
            throw new KafkaException("Failed to set name for '" + kerberosName + "' based on Kerberos authentication rules.", e);
        }
    }

    private KafkaPrincipal convertToKafkaPrincipal(Principal principal2) {
        return new KafkaPrincipal("User", principal2.getName());
    }

    @Override
    public void close() {
        if (this.oldPrincipalBuilder != null) {
            this.oldPrincipalBuilder.close();
        }
    }
}

