/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;

public class DescribeDelegationTokenResponse
extends AbstractResponse {
    private static final String TOKEN_DETAILS_KEY_NAME = "token_details";
    private static final String ISSUE_TIMESTAMP_KEY_NAME = "issue_timestamp";
    private static final String EXPIRY_TIMESTAMP_NAME = "expiry_timestamp";
    private static final String MAX_TIMESTAMP_NAME = "max_timestamp";
    private static final String TOKEN_ID_KEY_NAME = "token_id";
    private static final String HMAC_KEY_NAME = "hmac";
    private static final String OWNER_KEY_NAME = "owner";
    private static final String RENEWERS_KEY_NAME = "renewers";
    private final Errors error;
    private final List<DelegationToken> tokens;
    private final int throttleTimeMs;
    private static final Schema TOKEN_DETAILS_V0 = new Schema(new Field("owner", new Schema(CommonFields.PRINCIPAL_TYPE, CommonFields.PRINCIPAL_NAME), "token owner."), new Field("issue_timestamp", Type.INT64, "timestamp (in msec) when this token was generated."), new Field("expiry_timestamp", Type.INT64, "timestamp (in msec) at which this token expires."), new Field("max_timestamp", Type.INT64, "max life time of this token."), new Field("token_id", Type.STRING, "UUID to ensure uniqueness."), new Field("hmac", Type.BYTES, "HMAC of the delegation token to be expired."), new Field("renewers", new ArrayOf(new Schema(CommonFields.PRINCIPAL_TYPE, CommonFields.PRINCIPAL_NAME)), "An array of token renewers. Renewer is an Kafka PrincipalType and name string, who is allowed to renew this token before the max lifetime expires."));
    private static final Schema TOKEN_DESCRIBE_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("token_details", new ArrayOf(TOKEN_DETAILS_V0)), CommonFields.THROTTLE_TIME_MS);

    public DescribeDelegationTokenResponse(int throttleTimeMs, Errors error, List<DelegationToken> tokens) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.tokens = tokens;
    }

    public DescribeDelegationTokenResponse(int throttleTimeMs, Errors error) {
        this(throttleTimeMs, error, new ArrayList<DelegationToken>());
    }

    public DescribeDelegationTokenResponse(Struct struct) {
        Object[] requestStructs = struct.getArray(TOKEN_DETAILS_KEY_NAME);
        ArrayList<DelegationToken> tokens = new ArrayList<DelegationToken>();
        for (Object requestStructObj : requestStructs) {
            Struct singleRequestStruct = (Struct)requestStructObj;
            Struct ownerStruct = (Struct)singleRequestStruct.get(OWNER_KEY_NAME);
            KafkaPrincipal owner = new KafkaPrincipal(ownerStruct.get(CommonFields.PRINCIPAL_TYPE), ownerStruct.get(CommonFields.PRINCIPAL_NAME));
            long issueTimestamp = singleRequestStruct.getLong(ISSUE_TIMESTAMP_KEY_NAME);
            long expiryTimestamp = singleRequestStruct.getLong(EXPIRY_TIMESTAMP_NAME);
            long maxTimestamp = singleRequestStruct.getLong(MAX_TIMESTAMP_NAME);
            String tokenId = singleRequestStruct.getString(TOKEN_ID_KEY_NAME);
            ByteBuffer hmac = singleRequestStruct.getBytes(HMAC_KEY_NAME);
            Object[] renewerArray = singleRequestStruct.getArray(RENEWERS_KEY_NAME);
            ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
            if (renewerArray != null) {
                for (Object renewerObj : renewerArray) {
                    Struct renewerObjStruct = (Struct)renewerObj;
                    String principalType = renewerObjStruct.get(CommonFields.PRINCIPAL_TYPE);
                    String principalName = renewerObjStruct.get(CommonFields.PRINCIPAL_NAME);
                    renewers.add(new KafkaPrincipal(principalType, principalName));
                }
            }
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, renewers, issueTimestamp, maxTimestamp, expiryTimestamp);
            byte[] hmacBytes = new byte[hmac.remaining()];
            hmac.get(hmacBytes);
            DelegationToken tokenDetails = new DelegationToken(tokenInfo, hmacBytes);
            tokens.add(tokenDetails);
        }
        this.tokens = tokens;
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
    }

    public static DescribeDelegationTokenResponse parse(ByteBuffer buffer, short version) {
        return new DescribeDelegationTokenResponse(ApiKeys.DESCRIBE_DELEGATION_TOKEN.responseSchema(version).read(buffer));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_DELEGATION_TOKEN.responseSchema(version));
        ArrayList<Struct> tokenDetailsStructs = new ArrayList<Struct>(this.tokens.size());
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        for (DelegationToken token : this.tokens) {
            TokenInformation tokenInfo = token.tokenInfo();
            Struct singleRequestStruct = struct.instance(TOKEN_DETAILS_KEY_NAME);
            Struct ownerStruct = singleRequestStruct.instance(OWNER_KEY_NAME);
            ownerStruct.set(CommonFields.PRINCIPAL_TYPE, tokenInfo.owner().getPrincipalType());
            ownerStruct.set(CommonFields.PRINCIPAL_NAME, tokenInfo.owner().getName());
            singleRequestStruct.set(OWNER_KEY_NAME, (Object)ownerStruct);
            singleRequestStruct.set(ISSUE_TIMESTAMP_KEY_NAME, (Object)tokenInfo.issueTimestamp());
            singleRequestStruct.set(EXPIRY_TIMESTAMP_NAME, (Object)tokenInfo.expiryTimestamp());
            singleRequestStruct.set(MAX_TIMESTAMP_NAME, (Object)tokenInfo.maxTimestamp());
            singleRequestStruct.set(TOKEN_ID_KEY_NAME, (Object)tokenInfo.tokenId());
            singleRequestStruct.set(HMAC_KEY_NAME, (Object)ByteBuffer.wrap(token.hmac()));
            Object[] renewersArray = new Object[tokenInfo.renewers().size()];
            int i = 0;
            for (KafkaPrincipal principal2 : tokenInfo.renewers()) {
                Struct renewerStruct = singleRequestStruct.instance(RENEWERS_KEY_NAME);
                renewerStruct.set(CommonFields.PRINCIPAL_TYPE, principal2.getPrincipalType());
                renewerStruct.set(CommonFields.PRINCIPAL_NAME, principal2.getName());
                renewersArray[i++] = renewerStruct;
            }
            singleRequestStruct.set(RENEWERS_KEY_NAME, (Object)renewersArray);
            tokenDetailsStructs.add(singleRequestStruct);
        }
        struct.set(TOKEN_DETAILS_KEY_NAME, (Object)tokenDetailsStructs.toArray());
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        return struct;
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_DESCRIBE_RESPONSE_V0};
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    public List<DelegationToken> tokens() {
        return this.tokens;
    }
}

