/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import eu.europeana.metis.exception.BadContentException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class GeoUriWGS84Parser {
    private static final String DECIMAL_POINT_REGEX = "(?:\\.\\d+)?";
    private static final String ZEROES_DECIMAL_POINT_REGEX = "(?:\\.0+)?";
    private static final String LATITUDE_REGEX = "^[+-]?(?:90(?:\\.0+)?|(?:\\d|[1-8]\\d)(?:\\.\\d+)?)$";
    private static final Pattern LATITUDE_PATTERN = Pattern.compile("^[+-]?(?:90(?:\\.0+)?|(?:\\d|[1-8]\\d)(?:\\.\\d+)?)$");
    private static final String LONGITUDE_REGEX = "^[+-]?(?:180(?:\\.0+)?|(?:\\d|[1-9]\\d|1[0-7]\\d)(?:\\.\\d+)?)$";
    private static final Pattern LONGITUDE_PATTERN = Pattern.compile("^[+-]?(?:180(?:\\.0+)?|(?:\\d|[1-9]\\d|1[0-7]\\d)(?:\\.\\d+)?)$");
    private static final String ALTITUDE_REGEX = "^[+-]?\\d+(?:\\.\\d+)?$";
    private static final Pattern ALTITUDE_PATTERN = Pattern.compile("^[+-]?\\d+(?:\\.\\d+)?$");
    private static final String CRS_WGS_84 = "wgs84";
    private static final int MAX_NUMBER_COORDINATES = 3;
    private static final int MAX_DECIMAL_POINTS_TO_KEEP = 7;

    private GeoUriWGS84Parser() {
    }

    public static GeoCoordinates parse(String geoUriString) throws BadContentException {
        String[] geoUriParts = GeoUriWGS84Parser.validateGeoUriAndGetParts(geoUriString);
        return GeoUriWGS84Parser.validateGeoCoordinatesAndGet(geoUriParts[0]);
    }

    private static String[] validateGeoUriAndGetParts(String geoUriString) throws BadContentException {
        if (!geoUriString.matches("^\\S+$")) {
            throw new BadContentException("URI cannot have spaces");
        }
        if (!geoUriString.matches("^geo:.*$")) {
            throw new BadContentException("Invalid scheme value");
        }
        String[] schemeAndParts = geoUriString.split(":");
        if (schemeAndParts.length <= 1) {
            throw new BadContentException("There are no parts in the geo URI");
        }
        String[] geoUriParts = schemeAndParts[1].split(";");
        if (geoUriParts.length < 1) {
            throw new BadContentException("Invalid geo uri parts length");
        }
        LinkedList geoUriParameters = Arrays.stream(geoUriParts, 1, geoUriParts.length).map(s2 -> {
            String[] split = s2.split("=");
            return new GeoUriParameter(split[0], split[1]);
        }).collect(Collectors.toCollection(LinkedList::new));
        String crs = CRS_WGS_84;
        for (int i = 0; i < geoUriParameters.size(); ++i) {
            if ("crs".equalsIgnoreCase(((GeoUriParameter)geoUriParameters.get(i)).getName())) {
                crs = ((GeoUriParameter)geoUriParameters.get(i)).getValue();
                if (i != 0) {
                    throw new BadContentException("Invalid geo uri 'crs' parameter position");
                }
            }
            if (!"u".equalsIgnoreCase(((GeoUriParameter)geoUriParameters.get(i)).getName()) || i <= 1) continue;
            throw new BadContentException("Invalid geo uri 'u' parameter position");
        }
        if (!CRS_WGS_84.equalsIgnoreCase(crs)) {
            throw new BadContentException(String.format("Crs parameter value is not %s", CRS_WGS_84));
        }
        return geoUriParts;
    }

    private static GeoCoordinates validateGeoCoordinatesAndGet(String geoUriPart) throws BadContentException {
        Double altitude;
        String[] coordinates = geoUriPart.split(",");
        if (coordinates.length < 2 || coordinates.length > 3) {
            throw new BadContentException("Coordinates are not of valid length");
        }
        Matcher latitudeMatcher = LATITUDE_PATTERN.matcher(coordinates[0]);
        Matcher longitudeMatcher = LONGITUDE_PATTERN.matcher(coordinates[1]);
        if (latitudeMatcher.matches() && longitudeMatcher.matches()) {
            Matcher altitudeMatcher;
            altitude = null;
            if (coordinates.length == 3 && (altitudeMatcher = ALTITUDE_PATTERN.matcher(coordinates[2])).matches()) {
                altitude = Double.parseDouble(GeoUriWGS84Parser.truncateDecimalPoints(altitudeMatcher.group(0)));
            }
        } else {
            throw new BadContentException("Coordinates are invalid");
        }
        GeoCoordinates geoCoordinates = new GeoCoordinates(Double.parseDouble(GeoUriWGS84Parser.truncateDecimalPoints(latitudeMatcher.group(0))), Double.parseDouble(GeoUriWGS84Parser.truncateDecimalPoints(longitudeMatcher.group(0))), altitude);
        return geoCoordinates;
    }

    private static String truncateDecimalPoints(String decimalNumber) {
        String[] decimalNumberParts = decimalNumber.split("\\.");
        StringBuilder decimalNumberTruncated = new StringBuilder();
        if (decimalNumberParts.length >= 1) {
            decimalNumberTruncated.append(decimalNumberParts[0]);
        }
        if (decimalNumberParts.length > 1) {
            decimalNumberTruncated.append(".");
            decimalNumberTruncated.append(decimalNumberParts[1], 0, Math.min(decimalNumberParts[1].length(), 7));
        }
        return decimalNumberTruncated.toString();
    }

    public static class GeoCoordinates {
        private final Double latitude;
        private final Double longitude;
        private final Double altitude;

        public GeoCoordinates(Double latitude, Double longitude, Double altitude) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.altitude = altitude;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public Double getAltitude() {
            return this.altitude;
        }
    }

    private static class GeoUriParameter {
        private final String name;
        private final String value;

        public GeoUriParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

