/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.metis.indexing;

import com.google.common.base.Objects;
import eu.europeana.cloud.common.utils.DateAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataSetCleanerParameters
implements Serializable {
    private static final long serialVersionUID = 123456789L;
    private String dataSetId;
    private String targetIndexingEnv;
    @XmlElement(name="cleaningDate", required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date cleaningDate;

    public DataSetCleanerParameters(String dataSetId, String targetIndexingEnv, Date cleaningDate) {
        this.dataSetId = dataSetId;
        this.targetIndexingEnv = targetIndexingEnv;
        this.cleaningDate = cleaningDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetCleanerParameters cleanerParameters = (DataSetCleanerParameters)o;
        return Objects.equal(this.dataSetId, cleanerParameters.dataSetId) && Objects.equal(this.targetIndexingEnv, cleanerParameters.targetIndexingEnv) && Objects.equal(this.cleaningDate, cleanerParameters.cleaningDate);
    }

    public int hashCode() {
        return Objects.hashCode(this.dataSetId, this.targetIndexingEnv, this.cleaningDate);
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public String getTargetIndexingEnv() {
        return this.targetIndexingEnv;
    }

    public Date getCleaningDate() {
        return this.cleaningDate;
    }

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public void setTargetIndexingEnv(String targetIndexingEnv) {
        this.targetIndexingEnv = targetIndexingEnv;
    }

    public void setCleaningDate(Date cleaningDate) {
        this.cleaningDate = cleaningDate;
    }

    public String toString() {
        return "DataSetCleanerParameters(dataSetId=" + this.getDataSetId() + ", targetIndexingEnv=" + this.getTargetIndexingEnv() + ", cleaningDate=" + String.valueOf(this.getCleaningDate()) + ")";
    }

    public DataSetCleanerParameters() {
    }
}

