/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.utils;

import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.service.commons.utils.RetryableMethodExecutor;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class RetryAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryAspect.class);

    @Pointcut(value="@within(eu.europeana.cloud.common.annotation.Retryable)")
    public void pointcutTypeWithRetryableAnn() {
    }

    @Pointcut(value="@annotation(eu.europeana.cloud.common.annotation.Retryable)")
    public void pointcutMethodWithRetryableAnn() {
    }

    @Pointcut(value="pointcutTypeWithRetryableAnn() || pointcutMethodWithRetryableAnn()")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object retry(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        LOGGER.debug("Retry aspect called for '{}'", (Object)this.getMethod(proceedingJoinPoint));
        Retryable retryAnnotation = this.getAnnotationForMethodOrClass(proceedingJoinPoint);
        String errorMessage = RetryableMethodExecutor.createMessage(this.getMethod(proceedingJoinPoint), retryAnnotation, proceedingJoinPoint.getArgs());
        return RetryableMethodExecutor.execute(errorMessage, retryAnnotation.maxAttempts(), retryAnnotation.delay(), proceedingJoinPoint::proceed);
    }

    private Method getMethod(ProceedingJoinPoint proceedingJoinPoint) {
        return ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
    }

    private Retryable getAnnotationForMethodOrClass(ProceedingJoinPoint proceedingJoinPoint) {
        Retryable retryAnnotation = AnnotationUtils.findAnnotation(this.getMethod(proceedingJoinPoint), Retryable.class);
        if (retryAnnotation == null) {
            try {
                Method m4 = proceedingJoinPoint.getTarget().getClass().getMethod(this.getMethod(proceedingJoinPoint).getName(), this.getMethod(proceedingJoinPoint).getParameterTypes());
                retryAnnotation = m4.getAnnotation(Retryable.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (retryAnnotation == null) {
            retryAnnotation = proceedingJoinPoint.getTarget().getClass().getAnnotation(Retryable.class);
        }
        return retryAnnotation;
    }
}

