/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Revision;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@XmlRootElement
@JacksonXmlRootElement
@JsonRootName(value="representation")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Representation {
    static final String XSI_TYPE = "representation";
    @JacksonXmlProperty(namespace="http://www.w3.org/2001/XMLSchema-instance", localName="type", isAttribute=true)
    private final String xsiType = "representation";
    private String cloudId;
    private String representationName;
    private String version;
    private URI allVersionsUri;
    private URI uri;
    private String dataProvider;
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<File> files = new ArrayList<File>(0);
    private Date creationDate;
    private boolean persistent;
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<Revision> revisions = new ArrayList<Revision>(0);

    public Representation() {
    }

    public Representation(String cloudId, String representationName, String version, URI allVersionsUri, URI uri, String dataProvider, List<File> files, List<Revision> revisions, boolean persistent, Date creationDate) {
        this.cloudId = cloudId;
        this.representationName = representationName;
        this.version = version;
        this.allVersionsUri = allVersionsUri;
        this.uri = uri;
        this.dataProvider = dataProvider;
        this.files = files;
        this.revisions = revisions;
        this.persistent = persistent;
        this.creationDate = creationDate;
    }

    public Representation(Representation representation) {
        this(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion(), representation.getAllVersionsUri(), representation.getUri(), representation.getDataProvider(), Representation.cloneFiles(representation), Representation.cloneRevisions(representation), representation.isPersistent(), representation.getCreationDate());
    }

    public List<Revision> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(List<Revision> revisions) {
        this.revisions = revisions;
    }

    private static List<File> cloneFiles(Representation representation) {
        ArrayList<File> files = new ArrayList<File>(representation.getFiles().size());
        for (File file : representation.getFiles()) {
            files.add(new File(file));
        }
        return files;
    }

    private static List<Revision> cloneRevisions(Representation representation) {
        List<Revision> revisions = representation.getRevisions();
        if (revisions == null || revisions.isEmpty()) {
            return new ArrayList<Revision>();
        }
        ArrayList<Revision> clonedRevisions = new ArrayList<Revision>(revisions.size());
        for (Revision revision : revisions) {
            clonedRevisions.add(new Revision(revision));
        }
        return clonedRevisions;
    }

    public static Representation fromFields(String cloudId, String representationName, String version) {
        Representation r = new Representation();
        r.setCloudId(cloudId);
        r.setRepresentationName(representationName);
        r.setVersion(version);
        return r;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getRepresentationName() {
        return this.representationName;
    }

    public void setRepresentationName(String representationName) {
        this.representationName = representationName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(String dataProvider) {
        this.dataProvider = dataProvider;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public URI getAllVersionsUri() {
        return this.allVersionsUri;
    }

    public void setAllVersionsUri(URI allVersionsUri) {
        this.allVersionsUri = allVersionsUri;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI selfUri) {
        this.uri = selfUri;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @JsonIgnore
    public String getId() {
        return this.getACLId();
    }

    private String getACLId() {
        return this.getCloudId() + "/" + this.getRepresentationName() + "/" + this.getVersion();
    }

    public String toString() {
        return "Representation{cloudId=" + this.cloudId + ", representationName=" + this.representationName + ", version=" + this.version + ", dataProvider=" + this.dataProvider + ", files=" + String.valueOf(this.files) + ", revisions=" + String.valueOf(this.revisions) + ", creationDate=" + String.valueOf(this.creationDate) + ", persistent=" + this.persistent + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Representation)) {
            return false;
        }
        Representation other = (Representation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPersistent() != other.isPersistent()) {
            return false;
        }
        String this$xsiType = this.xsiType;
        String other$xsiType = other.xsiType;
        if (this$xsiType == null ? other$xsiType != null : !this$xsiType.equals(other$xsiType)) {
            return false;
        }
        String this$cloudId = this.getCloudId();
        String other$cloudId = other.getCloudId();
        if (this$cloudId == null ? other$cloudId != null : !this$cloudId.equals(other$cloudId)) {
            return false;
        }
        String this$representationName = this.getRepresentationName();
        String other$representationName = other.getRepresentationName();
        if (this$representationName == null ? other$representationName != null : !this$representationName.equals(other$representationName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        URI this$allVersionsUri = this.getAllVersionsUri();
        URI other$allVersionsUri = other.getAllVersionsUri();
        if (this$allVersionsUri == null ? other$allVersionsUri != null : !((Object)this$allVersionsUri).equals(other$allVersionsUri)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$dataProvider = this.getDataProvider();
        String other$dataProvider = other.getDataProvider();
        if (this$dataProvider == null ? other$dataProvider != null : !this$dataProvider.equals(other$dataProvider)) {
            return false;
        }
        List<File> this$files = this.getFiles();
        List<File> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Date this$creationDate = this.getCreationDate();
        Date other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        List<Revision> this$revisions = this.getRevisions();
        List<Revision> other$revisions = other.getRevisions();
        return !(this$revisions == null ? other$revisions != null : !((Object)this$revisions).equals(other$revisions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Representation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPersistent() ? 79 : 97);
        String $xsiType = this.xsiType;
        result = result * 59 + ($xsiType == null ? 43 : $xsiType.hashCode());
        String $cloudId = this.getCloudId();
        result = result * 59 + ($cloudId == null ? 43 : $cloudId.hashCode());
        String $representationName = this.getRepresentationName();
        result = result * 59 + ($representationName == null ? 43 : $representationName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        URI $allVersionsUri = this.getAllVersionsUri();
        result = result * 59 + ($allVersionsUri == null ? 43 : ((Object)$allVersionsUri).hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $dataProvider = this.getDataProvider();
        result = result * 59 + ($dataProvider == null ? 43 : $dataProvider.hashCode());
        List<File> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Date $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        List<Revision> $revisions = this.getRevisions();
        result = result * 59 + ($revisions == null ? 43 : ((Object)$revisions).hashCode());
        return result;
    }
}

