/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model;

import eu.europeana.cloud.service.mcs.Storage;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;

@XmlRootElement
public class File {
    private String fileName;
    private String mimeType;
    private String md5;
    private String date;
    private long contentLength;
    private URI contentUri;
    private Storage fileStorage;

    public File() {
        this.fileStorage = Storage.OBJECT_STORAGE;
    }

    public File(String fileName, String mimeType, String md5, String date, long contentLength, URI contentUri, Storage fileStorage) {
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.md5 = md5;
        this.date = date;
        this.contentLength = contentLength;
        this.contentUri = contentUri;
        this.fileStorage = fileStorage;
    }

    public File(String fileName, String mimeType, String md5, String date, long contentLength, URI contentUri) {
        this(fileName, mimeType, md5, date, contentLength, contentUri, Storage.OBJECT_STORAGE);
    }

    public File(File file) {
        this(file.getFileName(), file.getMimeType(), file.getMd5(), file.getDate(), file.getContentLength(), file.getContentUri(), file.fileStorage);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public URI getContentUri() {
        return this.contentUri;
    }

    public void setContentUri(URI contentUri) {
        this.contentUri = contentUri;
    }

    public Storage getFileStorage() {
        return this.fileStorage;
    }

    public void setFileStorage(Storage fileStorage) {
        this.fileStorage = fileStorage;
    }

    public String toString() {
        return "File{fileName='" + this.fileName + "', mimeType='" + this.mimeType + "', md5='" + this.md5 + "', date='" + this.date + "', contentLength=" + this.contentLength + ", contentUri=" + String.valueOf(this.contentUri) + ", fileStorage=" + String.valueOf((Object)this.fileStorage) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File other = (File)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        URI this$contentUri = this.getContentUri();
        URI other$contentUri = other.getContentUri();
        if (this$contentUri == null ? other$contentUri != null : !((Object)this$contentUri).equals(other$contentUri)) {
            return false;
        }
        Storage this$fileStorage = this.getFileStorage();
        Storage other$fileStorage = other.getFileStorage();
        return !(this$fileStorage == null ? other$fileStorage != null : !((Object)((Object)this$fileStorage)).equals((Object)other$fileStorage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof File;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        URI $contentUri = this.getContentUri();
        result = result * 59 + ($contentUri == null ? 43 : ((Object)$contentUri).hashCode());
        Storage $fileStorage = this.getFileStorage();
        result = result * 59 + ($fileStorage == null ? 43 : ((Object)((Object)$fileStorage)).hashCode());
        return result;
    }
}

