/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.dps.rest;

import com.fasterxml.jackson.core.util.JacksonFeature;
import eu.europeana.cloud.common.model.dps.MetisDataset;
import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.exception.DPSClientException;
import eu.europeana.cloud.service.dps.exception.DPSExceptionProvider;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.cloud.service.dps.metis.indexing.DataSetCleanerParameters;
import eu.europeana.cloud.service.dps.metis.indexing.TargetIndexingDatabase;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpsClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DpsClient.class);
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MILLIS = 20000;
    private static final int DEFAULT_READ_TIMEOUT_IN_MILLIS = 60000;
    public static final String TASK_CANT_BE_KILLED_MESSAGE = "Task Can't be killed";
    private final String dpsUrl;
    private final Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();

    public DpsClient(String dpsUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this.client.register(HttpAuthenticationFeature.basic(username, password));
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
        this.dpsUrl = dpsUrl;
    }

    public DpsClient(String dpsUrl, String username, String password) {
        this(dpsUrl, username, password, 20000, 60000);
    }

    public DpsClient(String dpsUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this.client.property("jersey.config.client.connectTimeout", connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", readTimeoutInMillis);
        this.dpsUrl = dpsUrl;
    }

    public DpsClient(String dpsUrl) {
        this(dpsUrl, 20000, 60000);
    }

    public long submitTask(DpsTask task, String topologyName) throws DpsException {
        URI uri = this.manageResponse(new ResponseParams<URI>(URI.class, Response.Status.CREATED), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks").resolveTemplate("topologyName", topologyName).request().post(Entity.json(task)), "Submit Task Was not successful");
        return this.getTaskId(uri);
    }

    public void cleanMetisIndexingDataset(String topologyName, long taskId, DataSetCleanerParameters dataSetCleanerParameters) throws DpsException {
        this.manageResponse(new ResponseParams<Void>(Void.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/cleaner").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).request().post(Entity.json(dataSetCleanerParameters)), "Cleaning a dataset was not successful");
    }

    public Response.StatusType topologyPermit(String topologyName, String username) throws DpsException {
        Form form = new Form();
        form.param("username", username);
        return this.manageResponse(new ResponseParams<Response.StatusType>(Response.StatusType.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/permit").resolveTemplate("topologyName", topologyName).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE)), "Granting permission was not successful");
    }

    public TaskInfo getTaskProgress(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<TaskInfo>(TaskInfo.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/progress").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).request().get(), "Task progress cannot be read");
    }

    public long getTotalMetisDatabaseRecords(String datasetId, TargetIndexingDatabase database) throws DpsException {
        MetisDataset metisDataset = this.manageResponse(new ResponseParams<MetisDataset>(MetisDataset.class), () -> this.client.target(this.dpsUrl).path("/metis-datasets/{datasetId}").resolveTemplate("datasetId", datasetId).queryParam("database", new Object[]{database}).request().get(), "Error while retrieving total metis database records");
        return metisDataset.getSize();
    }

    public List<SubTaskInfo> getDetailedTaskReport(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<List<SubTaskInfo>>(new GenericType<List<SubTaskInfo>>(this){}), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/reports/details").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).request().get(), "Error while retrieving detailed task report");
    }

    public List<SubTaskInfo> getDetailedTaskReportBetweenChunks(String topologyName, long taskId, int from, int to) throws DpsException {
        return this.manageResponse(new ResponseParams<List<SubTaskInfo>>(new GenericType<List<SubTaskInfo>>(this){}), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/reports/details").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).queryParam("from", from).queryParam("to", to).request().get(), "Error while retrieving detailed task report (witch chunks)");
    }

    public List<NodeReport> getElementReport(String topologyName, long taskId, String elementPath) throws DpsException {
        return this.manageResponse(new ResponseParams<List<NodeReport>>(new GenericType<List<NodeReport>>(this){}), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/reports/element").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).queryParam("path", elementPath).request().get(), "Error while retrieving reports element");
    }

    public TaskErrorsInfo getTaskErrorsReport(String topologyName, long taskId, String error, int idsCount) throws DpsException {
        return this.manageResponse(new ResponseParams<TaskErrorsInfo>(TaskErrorsInfo.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/reports/errors").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).queryParam("error", error).queryParam("idsCount", idsCount).request().get(), "Error while retrieving task error report");
    }

    public boolean checkIfErrorReportExists(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<Response.StatusType>(Response.StatusType.class, Response.Status.OK, Response.Status.METHOD_NOT_ALLOWED), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/reports/errors").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).request().head(), "Error while checking error report exits").getStatusCode() == Response.Status.OK.getStatusCode();
    }

    public StatisticsReport getTaskStatisticsReport(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<StatisticsReport>(StatisticsReport.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/statistics").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).request().get(), "Task statistics report cannot be read");
    }

    public String killTask(String topologyName, long taskId, String info) throws DpsException {
        if (info == null) {
            return this.killTask(topologyName, taskId);
        }
        return this.manageResponse(new ResponseParams<String>(String.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/kill").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).queryParam("info", info).request().post(null), TASK_CANT_BE_KILLED_MESSAGE);
    }

    private String killTask(String topologyName, long taskId) throws DpsException {
        return this.manageResponse(new ResponseParams<String>(String.class), () -> this.client.target(this.dpsUrl).path("/{topologyName}/tasks/{taskId}/kill").resolveTemplate("topologyName", topologyName).resolveTemplate("taskId", taskId).request().post(null), TASK_CANT_BE_KILLED_MESSAGE);
    }

    public List<String> searchPublishedDatasetRecords(String datasetId, List<String> recordsIds) throws DpsException {
        return this.manageResponse(new ResponseParams<List<String>>(new GenericType<List<String>>(this){}), () -> this.client.target(this.dpsUrl).path("/metis-datasets/{datasetId}/records/published/search").resolveTemplate("datasetId", datasetId).request().post(Entity.json(recordsIds)), "Error while searching published dataset records");
    }

    @Override
    public void close() {
        this.client.close();
    }

    private long getTaskId(URI uri) {
        String[] elements = uri.getRawPath().split("/");
        return Long.parseLong(elements[elements.length - 1]);
    }

    private <T> T manageResponse(ResponseParams<T> responseParameters, Supplier<Response> responseSupplier, String errorMessage) throws DpsException {
        Response response = responseSupplier.get();
        try {
            response.bufferEntity();
            if (responseParameters.isStatusCodeValid(response.getStatus())) {
                T t2 = this.readEntityByClass(responseParameters, response);
                return t2;
            }
            try {
                if (response.getStatus() == 503) {
                    throw DPSExceptionProvider.createException(errorMessage, "Service unavailable", new ServiceUnavailableException());
                }
                if (response.getStatus() == 404) {
                    throw DPSExceptionProvider.createException(errorMessage, "Endpoint not found", new NotFoundException());
                }
                ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
                throw DPSExceptionProvider.createException(errorInfo);
            }
            catch (DPSClientException | DpsException dpsException) {
                throw dpsException;
            }
            catch (ProcessingException processingException) {
                String message = String.format("Could not deserialize response with statusCode: %d; message: %s", response.getStatus(), response.readEntity(String.class));
                throw DPSExceptionProvider.createException(errorMessage, message, processingException);
            }
            catch (Exception otherExceptions) {
                throw DPSExceptionProvider.createException(errorMessage, "Other exception", otherExceptions);
            }
        }
        finally {
            this.closeResponse(response);
        }
    }

    private <T> T readEntityByClass(ResponseParams<T> responseParameters, Response response) {
        if (responseParameters.getExpectedClass() == Void.class) {
            return null;
        }
        if (responseParameters.getExpectedClass() == Boolean.class) {
            return (T)Boolean.TRUE;
        }
        if (responseParameters.getExpectedClass() == URI.class) {
            return (T)response.getLocation();
        }
        if (responseParameters.getExpectedClass() == Response.StatusType.class) {
            return (T)response.getStatusInfo();
        }
        if (responseParameters.getGenericType() != null) {
            return response.readEntity(responseParameters.getGenericType());
        }
        return response.readEntity(responseParameters.getExpectedClass());
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    protected void finalize() throws Throwable {
        LOGGER.warn("'{}.finalize()' called!!!\n{}", (Object)this.getClass().getSimpleName(), (Object)Thread.currentThread().getStackTrace());
        this.client.close();
    }

    private static class ResponseParams<T> {
        private Class<T> expectedClass;
        private GenericType<T> genericType;
        private Response.Status[] validStatuses;

        public ResponseParams(Class<T> expectedClass) {
            this(expectedClass, Response.Status.OK);
        }

        public ResponseParams(Class<T> expectedClass, Response.Status validStatus) {
            this(expectedClass, (GenericType<T>)null, new Response.Status[]{validStatus});
        }

        public ResponseParams(GenericType<T> genericType) {
            this(null, genericType, new Response.Status[]{Response.Status.OK});
        }

        public ResponseParams(Class<T> expectedClass, Response.Status ... validStatuses) {
            this(expectedClass, (GenericType<T>)null, validStatuses);
        }

        public boolean isStatusCodeValid(Integer statusCode) {
            return Arrays.stream(this.validStatuses).map(Response.Status::getStatusCode).anyMatch(statusCode::equals);
        }

        public ResponseParams(Class<T> expectedClass, GenericType<T> genericType, Response.Status[] validStatuses) {
            this.expectedClass = expectedClass;
            this.genericType = genericType;
            this.validStatuses = validStatuses;
        }

        public Class<T> getExpectedClass() {
            return this.expectedClass;
        }

        public GenericType<T> getGenericType() {
            return this.genericType;
        }

        public Response.Status[] getValidStatuses() {
            return this.validStatuses;
        }
    }
}

