/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.cassandra;

import com.datastax.driver.core.AtomicMonotonicTimestampGenerator;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CassandraConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraConnectionProvider.class);
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.QUORUM;
    private final Cluster cluster;
    private final Session session;
    private final String hosts;
    private final String port;
    private final String keyspaceName;

    public CassandraConnectionProvider(String hosts, int port, String keyspaceName) {
        this.hosts = hosts;
        this.port = String.valueOf(port);
        this.keyspaceName = keyspaceName;
        String[] contactPoints = hosts.split(",");
        this.cluster = this.getClusterBuilder(port, contactPoints).build();
        this.init();
        this.session = this.cluster.connect(keyspaceName);
    }

    public CassandraConnectionProvider(String hosts, int port, String keyspaceName, String userName, String password) {
        this.hosts = hosts;
        this.port = String.valueOf(port);
        this.keyspaceName = keyspaceName;
        String[] contactPoints = hosts.split(",");
        this.cluster = this.getClusterBuilder(port, contactPoints).withCredentials(userName, password).build();
        this.init();
        this.session = this.cluster.connect(keyspaceName);
    }

    private void init() {
        Metadata metadata = this.cluster.getMetadata();
        LOGGER.info("Connected to cluster: {}", (Object)metadata.getClusterName());
        for (Host h2 : metadata.getAllHosts()) {
            LOGGER.info("Data center: {}; Hosts: {}; Rack: {}", h2.getDatacenter(), h2.getBroadcastAddress(), h2.getRack());
        }
    }

    private Cluster.Builder getClusterBuilder(int port, String[] contactPoints) {
        return Cluster.builder().addContactPoints(contactPoints).withPort(port).withProtocolVersion(ProtocolVersion.V3).withQueryOptions(new QueryOptions().setConsistencyLevel(DEFAULT_CONSISTENCY_LEVEL)).withTimestampGenerator(new AtomicMonotonicTimestampGenerator());
    }

    @PreDestroy
    public void closeConnections() {
        LOGGER.info("Cluster is shutting down.");
        this.cluster.close();
    }

    public Session getSession() {
        return this.session;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return DEFAULT_CONSISTENCY_LEVEL;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getPort() {
        return this.port;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public Metadata getMetadata() {
        return this.cluster.getMetadata();
    }
}

