/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.http.conn.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingDnsResolver
implements DnsResolver {
    private Logger log = LoggerFactory.getLogger(TimingDnsResolver.class);
    private final DnsResolver delegate;

    public TimingDnsResolver(DnsResolver delegate) {
        this.delegate = delegate;
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        StopWatch watch = null;
        if (this.log.isInfoEnabled()) {
            watch = new StopWatch();
            watch.start();
        }
        try {
            InetAddress[] inetAddressArray = this.delegate.resolve(host);
            return inetAddressArray;
        }
        finally {
            if (watch != null) {
                this.log.info("resolved {} in {} ms", (Object)host, (Object)watch.getTime());
            }
        }
    }
}

