/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.driver.core.ProtocolVersion;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Crc {
    private static final Logger logger = LoggerFactory.getLogger(Crc.class);
    private static final FastThreadLocal<CRC32> crc32 = new FastThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };
    private static final byte[] initialBytes = new byte[]{-6, 45, 85, -54};
    private static final CrcUpdater CRC_UPDATER = Crc.selectCrcUpdater();
    private static final int CRC24_INIT = 8867936;
    private static final int CRC24_POLY = 26693387;

    Crc() {
    }

    static int computeCrc32(ByteBuf buffer) {
        CRC32 crc = Crc.newCrc32();
        CRC_UPDATER.update(crc, buffer);
        return (int)crc.getValue();
    }

    private static CRC32 newCrc32() {
        CRC32 crc = crc32.get();
        crc.reset();
        crc.update(initialBytes);
        return crc;
    }

    static int computeCrc24(long bytes, int len) {
        int crc = 8867936;
        while (len-- > 0) {
            crc = (int)((long)crc ^ (bytes & 0xFFL) << 16);
            bytes >>= 8;
            for (int i = 0; i < 8; ++i) {
                if (((crc <<= 1) & 0x1000000) == 0) continue;
                crc ^= 0x1974F0B;
            }
        }
        return crc;
    }

    private static CrcUpdater selectCrcUpdater() {
        try {
            CRC32.class.getDeclaredMethod("update", ByteBuffer.class);
            return new Java8CrcUpdater();
        }
        catch (Exception e) {
            logger.warn("It looks like you are running Java 7 or below. CRC checks (used in protocol {} and above) will require a memory copy, which can negatively impact performance. Consider using a more modern VM.", (Object)ProtocolVersion.V5, (Object)e);
            return new Java6CrcUpdater();
        }
    }

    @IgnoreJDK6Requirement
    private static class Java8CrcUpdater
    implements CrcUpdater {
        private Java8CrcUpdater() {
        }

        @Override
        public void update(CRC32 crc, ByteBuf buffer) {
            crc.update(buffer.internalNioBuffer(buffer.readerIndex(), buffer.readableBytes()));
        }
    }

    private static class Java6CrcUpdater
    implements CrcUpdater {
        private Java6CrcUpdater() {
        }

        @Override
        public void update(CRC32 crc, ByteBuf buffer) {
            if (buffer.hasArray()) {
                crc.update(buffer.array(), buffer.arrayOffset(), buffer.readableBytes());
            } else {
                byte[] bytes = new byte[buffer.readableBytes()];
                buffer.getBytes(buffer.readerIndex(), bytes);
                crc.update(bytes);
            }
        }
    }

    private static interface CrcUpdater {
        public void update(CRC32 var1, ByteBuf var2);
    }
}

