/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.userdetails.cache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class EhCacheBasedUserCache
implements UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog(EhCacheBasedUserCache.class);
    private Ehcache cache;

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cache, "cache mandatory");
    }

    public Ehcache getCache() {
        return this.cache;
    }

    @Override
    public UserDetails getUserFromCache(String username) {
        Element element = this.cache.get((Serializable)((Object)username));
        if (logger.isDebugEnabled()) {
            logger.debug("Cache hit: " + (element != null) + "; username: " + username);
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    @Override
    public void putUserInCache(UserDetails user) {
        Element element = new Element((Serializable)((Object)user.getUsername()), (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug("Cache put: " + element.getKey());
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cache remove: " + user.getUsername());
        }
        this.removeUserFromCache(user.getUsername());
    }

    @Override
    public void removeUserFromCache(String username) {
        this.cache.remove((Serializable)((Object)username));
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }
}

