/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.instrumentation;

import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;

public class JavassistHelper {
    public static String returnValue(CtBehavior method) throws NotFoundException {
        String returnValue = "";
        if (JavassistHelper.methodReturnsValue(method)) {
            returnValue = " returns: \" + $_ + \".";
        }
        return returnValue;
    }

    private static boolean methodReturnsValue(CtBehavior method) throws NotFoundException {
        if (!(method instanceof CtMethod)) {
            return false;
        }
        CtClass returnType = ((CtMethod)method).getReturnType();
        String returnTypeName = returnType.getName();
        boolean isVoidMethod = "void".equals(returnTypeName);
        boolean methodReturnsValue = !isVoidMethod;
        return methodReturnsValue;
    }

    public static String getSignature(CtBehavior method) throws NotFoundException {
        CtClass[] parameterTypes = method.getParameterTypes();
        CodeAttribute codeAttribute = method.getMethodInfo().getCodeAttribute();
        LocalVariableAttribute locals = null;
        if (codeAttribute != null) {
            AttributeInfo attribute = codeAttribute.getAttribute("LocalVariableTable");
            locals = (LocalVariableAttribute)attribute;
        }
        String methodName = method.getName();
        StringBuilder sb = new StringBuilder(methodName).append("(\" ");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(" + \", \" ");
            }
            CtClass parameterType = parameterTypes[i];
            boolean isArray = parameterType.isArray();
            CtClass arrayType = parameterType.getComponentType();
            if (isArray) {
                while (arrayType.isArray()) {
                    arrayType = arrayType.getComponentType();
                }
            }
            sb.append(" + \"");
            try {
                sb.append(JavassistHelper.parameterNameFor(method, locals, i));
            }
            catch (Exception e) {
                sb.append(i + 1);
            }
            sb.append("\" + \"=");
            if (parameterType.isPrimitive()) {
                sb.append("\"+ $").append(i + 1);
                continue;
            }
            String s2 = "org.slf4j.instrumentation.ToStringHelper.render";
            sb.append("\"+ ").append(s2).append("($").append(i + 1).append(')');
        }
        sb.append("+\")");
        String signature = sb.toString();
        return signature;
    }

    static String parameterNameFor(CtBehavior method, LocalVariableAttribute locals, int i) {
        if (locals == null) {
            return Integer.toString(i + 1);
        }
        int modifiers = method.getModifiers();
        int j = i;
        if (Modifier.isSynchronized(modifiers)) {
            ++j;
        }
        if (!Modifier.isStatic(modifiers)) {
            ++j;
        }
        String variableName = locals.variableName(j);
        return variableName;
    }
}

