/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.List;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.stats.SampledStat;

public class Min
extends SampledStat {
    public Min() {
        super(Double.MAX_VALUE);
    }

    @Override
    protected void update(SampledStat.Sample sample, MetricConfig config, double value, long now) {
        sample.value = Math.min(sample.value, value);
    }

    @Override
    public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
        double min2 = Double.MAX_VALUE;
        for (SampledStat.Sample sample : samples) {
            min2 = Math.min(min2, sample.value);
        }
        return min2;
    }
}

