/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.utils;

import eu.europeana.cloud.common.annotation.Retryable;
import eu.europeana.cloud.service.commons.utils.RetryInterruptedException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableMethodExecutor {
    private static final String ATTEMPT_COUNT_PROPERTY_NAME = "ECLOUD_OVERRIDE_RETRIES_ATTEMPT_COUNT";
    public static final Integer OVERRIDE_ATTEMPT_COUNT = RetryableMethodExecutor.getSystemPropertyOrEnvVariable("ECLOUD_OVERRIDE_RETRIES_ATTEMPT_COUNT");
    private static final String DELAY_VALUE_PROPERTY_NAME = "ECLOUD_OVERRIDE_RETRIES_DELAY";
    public static final Integer OVERRIDE_DELAY_BETWEEN_ATTEMPTS = RetryableMethodExecutor.getSystemPropertyOrEnvVariable("ECLOUD_OVERRIDE_RETRIES_DELAY");
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryableMethodExecutor.class);
    public static final int DEFAULT_REST_ATTEMPTS = 8;
    public static final int DELAY_BETWEEN_REST_ATTEMPTS = 5000;

    private static Integer getSystemPropertyOrEnvVariable(String propertyName) {
        String jvmVariable = System.getProperty(propertyName);
        if (jvmVariable != null) {
            return !jvmVariable.isEmpty() ? Integer.valueOf(Integer.parseInt(jvmVariable)) : null;
        }
        return Optional.ofNullable(System.getenv(propertyName)).map(Integer::parseInt).orElse(null);
    }

    public static boolean areRetryParamsOverridden() {
        return OVERRIDE_ATTEMPT_COUNT != null || OVERRIDE_DELAY_BETWEEN_ATTEMPTS != null;
    }

    public static <V, E extends Exception> V executeOnRest(String errorMessage, GenericCallable<V, E> callable) throws E {
        return RetryableMethodExecutor.execute(errorMessage, 8, 5000, callable);
    }

    public static <V, E extends Throwable> V execute(String errorMessage, int maxAttempts, int sleepTimeBetweenRetriesMs, GenericCallable<V, E> callable) throws E {
        maxAttempts = Optional.ofNullable(OVERRIDE_ATTEMPT_COUNT).orElse(maxAttempts);
        sleepTimeBetweenRetriesMs = Optional.ofNullable(OVERRIDE_DELAY_BETWEEN_ATTEMPTS).orElse(sleepTimeBetweenRetriesMs);
        while (true) {
            try {
                return callable.call();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RetryInterruptedException(e);
            }
            catch (Exception e) {
                if (--maxAttempts > 0) {
                    LOGGER.warn("{} - {} Retries Left {} ", errorMessage, e.getMessage(), maxAttempts, e);
                    RetryableMethodExecutor.waitForSpecificTime(sleepTimeBetweenRetriesMs);
                    continue;
                }
                LOGGER.error(errorMessage);
                throw e;
            }
            break;
        }
    }

    private static void waitForSpecificTime(int milliSecond) {
        try {
            Thread.sleep(milliSecond);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RetryInterruptedException(e);
        }
    }

    public static <T> T createRetryProxy(T target) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(target.getClass().getClassLoader());
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallback((obj, method, args, methodProxy) -> RetryableMethodExecutor.retryFromAnnotation(target, method, args));
        return (T)enhancer.create();
    }

    private static <T> Object retryFromAnnotation(T target, Method method, Object[] args) throws Throwable {
        Retryable retryAnnotation = RetryableMethodExecutor.getRetryAnnotation(method);
        if (retryAnnotation != null) {
            return RetryableMethodExecutor.execute(RetryableMethodExecutor.createMessage(method, retryAnnotation, args), retryAnnotation.maxAttempts(), retryAnnotation.delay(), () -> RetryableMethodExecutor.invokeWithThrowingOriginalException(target, method, args));
        }
        return RetryableMethodExecutor.executeWithoutRetry(target, method, args);
    }

    private static Retryable getRetryAnnotation(Method method) {
        return Optional.ofNullable(method.getAnnotation(Retryable.class)).orElse(method.getDeclaringClass().getAnnotation(Retryable.class));
    }

    private static <T> Object executeWithoutRetry(T target, Method method, Object[] args) throws Throwable {
        if (!Modifier.isPublic(method.getModifiers())) {
            method.setAccessible(true);
        }
        return RetryableMethodExecutor.invokeWithThrowingOriginalException(target, method, args);
    }

    private static <T> Object invokeWithThrowingOriginalException(T target, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (ReflectiveOperationException e) {
            throw Optional.ofNullable(e.getCause()).orElse(e);
        }
    }

    public static String createMessage(Method method, Retryable annotation, Object[] args) {
        String result = !annotation.errorMessage().isEmpty() ? annotation.errorMessage() : String.format("Error while invoking method '%s' with args: %s", method, Arrays.toString(args));
        return result;
    }

    public static interface GenericCallable<V, E extends Throwable> {
        public V call() throws E, InterruptedException;
    }
}

