/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model.dps;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.europeana.cloud.common.model.dps.TaskState;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class TaskInfo {
    public static final int UNKNOWN_EXPECTED_RECORDS_NUMBER = -1;
    private long id;
    private String topologyName;
    private TaskState state;
    private String stateDescription;
    private Date sentTimestamp;
    private Date startTimestamp;
    private Date finishTimestamp;
    private int expectedRecordsNumber;
    private int processedRecordsCount;
    private int ignoredRecordsCount;
    private int deletedRecordsCount;
    private int processedErrorsCount;
    private int deletedErrorsCount;
    private int expectedPostProcessedRecordsNumber;
    private int postProcessedRecordsCount;
    private String definition;

    @JsonIgnore
    @XmlTransient
    public boolean isProcessedOnStorm() {
        return this.getProcessedRecordsCount() + this.getIgnoredRecordsCount() + this.getDeletedRecordsCount() == this.getExpectedRecordsNumber();
    }

    public static TaskInfoBuilder builder() {
        return new TaskInfoBuilder();
    }

    public long getId() {
        return this.id;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public TaskState getState() {
        return this.state;
    }

    public String getStateDescription() {
        return this.stateDescription;
    }

    public Date getSentTimestamp() {
        return this.sentTimestamp;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getFinishTimestamp() {
        return this.finishTimestamp;
    }

    public int getExpectedRecordsNumber() {
        return this.expectedRecordsNumber;
    }

    public int getProcessedRecordsCount() {
        return this.processedRecordsCount;
    }

    public int getIgnoredRecordsCount() {
        return this.ignoredRecordsCount;
    }

    public int getDeletedRecordsCount() {
        return this.deletedRecordsCount;
    }

    public int getProcessedErrorsCount() {
        return this.processedErrorsCount;
    }

    public int getDeletedErrorsCount() {
        return this.deletedErrorsCount;
    }

    public int getExpectedPostProcessedRecordsNumber() {
        return this.expectedPostProcessedRecordsNumber;
    }

    public int getPostProcessedRecordsCount() {
        return this.postProcessedRecordsCount;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public void setStateDescription(String stateDescription) {
        this.stateDescription = stateDescription;
    }

    public void setSentTimestamp(Date sentTimestamp) {
        this.sentTimestamp = sentTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public void setFinishTimestamp(Date finishTimestamp) {
        this.finishTimestamp = finishTimestamp;
    }

    public void setExpectedRecordsNumber(int expectedRecordsNumber) {
        this.expectedRecordsNumber = expectedRecordsNumber;
    }

    public void setProcessedRecordsCount(int processedRecordsCount) {
        this.processedRecordsCount = processedRecordsCount;
    }

    public void setIgnoredRecordsCount(int ignoredRecordsCount) {
        this.ignoredRecordsCount = ignoredRecordsCount;
    }

    public void setDeletedRecordsCount(int deletedRecordsCount) {
        this.deletedRecordsCount = deletedRecordsCount;
    }

    public void setProcessedErrorsCount(int processedErrorsCount) {
        this.processedErrorsCount = processedErrorsCount;
    }

    public void setDeletedErrorsCount(int deletedErrorsCount) {
        this.deletedErrorsCount = deletedErrorsCount;
    }

    public void setExpectedPostProcessedRecordsNumber(int expectedPostProcessedRecordsNumber) {
        this.expectedPostProcessedRecordsNumber = expectedPostProcessedRecordsNumber;
    }

    public void setPostProcessedRecordsCount(int postProcessedRecordsCount) {
        this.postProcessedRecordsCount = postProcessedRecordsCount;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo other = (TaskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$topologyName = this.getTopologyName();
        String other$topologyName = other.getTopologyName();
        if (this$topologyName == null ? other$topologyName != null : !this$topologyName.equals(other$topologyName)) {
            return false;
        }
        TaskState this$state = this.getState();
        TaskState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$stateDescription = this.getStateDescription();
        String other$stateDescription = other.getStateDescription();
        if (this$stateDescription == null ? other$stateDescription != null : !this$stateDescription.equals(other$stateDescription)) {
            return false;
        }
        Date this$sentTimestamp = this.getSentTimestamp();
        Date other$sentTimestamp = other.getSentTimestamp();
        if (this$sentTimestamp == null ? other$sentTimestamp != null : !((Object)this$sentTimestamp).equals(other$sentTimestamp)) {
            return false;
        }
        Date this$startTimestamp = this.getStartTimestamp();
        Date other$startTimestamp = other.getStartTimestamp();
        if (this$startTimestamp == null ? other$startTimestamp != null : !((Object)this$startTimestamp).equals(other$startTimestamp)) {
            return false;
        }
        Date this$finishTimestamp = this.getFinishTimestamp();
        Date other$finishTimestamp = other.getFinishTimestamp();
        if (this$finishTimestamp == null ? other$finishTimestamp != null : !((Object)this$finishTimestamp).equals(other$finishTimestamp)) {
            return false;
        }
        if (this.getExpectedRecordsNumber() != other.getExpectedRecordsNumber()) {
            return false;
        }
        if (this.getProcessedRecordsCount() != other.getProcessedRecordsCount()) {
            return false;
        }
        if (this.getIgnoredRecordsCount() != other.getIgnoredRecordsCount()) {
            return false;
        }
        if (this.getDeletedRecordsCount() != other.getDeletedRecordsCount()) {
            return false;
        }
        if (this.getProcessedErrorsCount() != other.getProcessedErrorsCount()) {
            return false;
        }
        if (this.getDeletedErrorsCount() != other.getDeletedErrorsCount()) {
            return false;
        }
        if (this.getExpectedPostProcessedRecordsNumber() != other.getExpectedPostProcessedRecordsNumber()) {
            return false;
        }
        if (this.getPostProcessedRecordsCount() != other.getPostProcessedRecordsCount()) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        return !(this$definition == null ? other$definition != null : !this$definition.equals(other$definition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $topologyName = this.getTopologyName();
        result = result * 59 + ($topologyName == null ? 43 : $topologyName.hashCode());
        TaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $stateDescription = this.getStateDescription();
        result = result * 59 + ($stateDescription == null ? 43 : $stateDescription.hashCode());
        Date $sentTimestamp = this.getSentTimestamp();
        result = result * 59 + ($sentTimestamp == null ? 43 : ((Object)$sentTimestamp).hashCode());
        Date $startTimestamp = this.getStartTimestamp();
        result = result * 59 + ($startTimestamp == null ? 43 : ((Object)$startTimestamp).hashCode());
        Date $finishTimestamp = this.getFinishTimestamp();
        result = result * 59 + ($finishTimestamp == null ? 43 : ((Object)$finishTimestamp).hashCode());
        result = result * 59 + this.getExpectedRecordsNumber();
        result = result * 59 + this.getProcessedRecordsCount();
        result = result * 59 + this.getIgnoredRecordsCount();
        result = result * 59 + this.getDeletedRecordsCount();
        result = result * 59 + this.getProcessedErrorsCount();
        result = result * 59 + this.getDeletedErrorsCount();
        result = result * 59 + this.getExpectedPostProcessedRecordsNumber();
        result = result * 59 + this.getPostProcessedRecordsCount();
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        return result;
    }

    public String toString() {
        return "TaskInfo(id=" + this.getId() + ", topologyName=" + this.getTopologyName() + ", state=" + this.getState() + ", stateDescription=" + this.getStateDescription() + ", sentTimestamp=" + this.getSentTimestamp() + ", startTimestamp=" + this.getStartTimestamp() + ", finishTimestamp=" + this.getFinishTimestamp() + ", expectedRecordsNumber=" + this.getExpectedRecordsNumber() + ", processedRecordsCount=" + this.getProcessedRecordsCount() + ", ignoredRecordsCount=" + this.getIgnoredRecordsCount() + ", deletedRecordsCount=" + this.getDeletedRecordsCount() + ", processedErrorsCount=" + this.getProcessedErrorsCount() + ", deletedErrorsCount=" + this.getDeletedErrorsCount() + ", expectedPostProcessedRecordsNumber=" + this.getExpectedPostProcessedRecordsNumber() + ", postProcessedRecordsCount=" + this.getPostProcessedRecordsCount() + ", definition=" + this.getDefinition() + ")";
    }

    public TaskInfo(long id, String topologyName, TaskState state, String stateDescription, Date sentTimestamp, Date startTimestamp, Date finishTimestamp, int expectedRecordsNumber, int processedRecordsCount, int ignoredRecordsCount, int deletedRecordsCount, int processedErrorsCount, int deletedErrorsCount, int expectedPostProcessedRecordsNumber, int postProcessedRecordsCount, String definition) {
        this.id = id;
        this.topologyName = topologyName;
        this.state = state;
        this.stateDescription = stateDescription;
        this.sentTimestamp = sentTimestamp;
        this.startTimestamp = startTimestamp;
        this.finishTimestamp = finishTimestamp;
        this.expectedRecordsNumber = expectedRecordsNumber;
        this.processedRecordsCount = processedRecordsCount;
        this.ignoredRecordsCount = ignoredRecordsCount;
        this.deletedRecordsCount = deletedRecordsCount;
        this.processedErrorsCount = processedErrorsCount;
        this.deletedErrorsCount = deletedErrorsCount;
        this.expectedPostProcessedRecordsNumber = expectedPostProcessedRecordsNumber;
        this.postProcessedRecordsCount = postProcessedRecordsCount;
        this.definition = definition;
    }

    public TaskInfo() {
    }

    public static class TaskInfoBuilder {
        private long id;
        private String topologyName;
        private TaskState state;
        private String stateDescription;
        private Date sentTimestamp;
        private Date startTimestamp;
        private Date finishTimestamp;
        private int expectedRecordsNumber;
        private int processedRecordsCount;
        private int ignoredRecordsCount;
        private int deletedRecordsCount;
        private int processedErrorsCount;
        private int deletedErrorsCount;
        private int expectedPostProcessedRecordsNumber;
        private int postProcessedRecordsCount;
        private String definition;

        TaskInfoBuilder() {
        }

        public TaskInfoBuilder id(long id) {
            this.id = id;
            return this;
        }

        public TaskInfoBuilder topologyName(String topologyName) {
            this.topologyName = topologyName;
            return this;
        }

        public TaskInfoBuilder state(TaskState state) {
            this.state = state;
            return this;
        }

        public TaskInfoBuilder stateDescription(String stateDescription) {
            this.stateDescription = stateDescription;
            return this;
        }

        public TaskInfoBuilder sentTimestamp(Date sentTimestamp) {
            this.sentTimestamp = sentTimestamp;
            return this;
        }

        public TaskInfoBuilder startTimestamp(Date startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public TaskInfoBuilder finishTimestamp(Date finishTimestamp) {
            this.finishTimestamp = finishTimestamp;
            return this;
        }

        public TaskInfoBuilder expectedRecordsNumber(int expectedRecordsNumber) {
            this.expectedRecordsNumber = expectedRecordsNumber;
            return this;
        }

        public TaskInfoBuilder processedRecordsCount(int processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public TaskInfoBuilder ignoredRecordsCount(int ignoredRecordsCount) {
            this.ignoredRecordsCount = ignoredRecordsCount;
            return this;
        }

        public TaskInfoBuilder deletedRecordsCount(int deletedRecordsCount) {
            this.deletedRecordsCount = deletedRecordsCount;
            return this;
        }

        public TaskInfoBuilder processedErrorsCount(int processedErrorsCount) {
            this.processedErrorsCount = processedErrorsCount;
            return this;
        }

        public TaskInfoBuilder deletedErrorsCount(int deletedErrorsCount) {
            this.deletedErrorsCount = deletedErrorsCount;
            return this;
        }

        public TaskInfoBuilder expectedPostProcessedRecordsNumber(int expectedPostProcessedRecordsNumber) {
            this.expectedPostProcessedRecordsNumber = expectedPostProcessedRecordsNumber;
            return this;
        }

        public TaskInfoBuilder postProcessedRecordsCount(int postProcessedRecordsCount) {
            this.postProcessedRecordsCount = postProcessedRecordsCount;
            return this;
        }

        public TaskInfoBuilder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public TaskInfo build() {
            return new TaskInfo(this.id, this.topologyName, this.state, this.stateDescription, this.sentTimestamp, this.startTimestamp, this.finishTimestamp, this.expectedRecordsNumber, this.processedRecordsCount, this.ignoredRecordsCount, this.deletedRecordsCount, this.processedErrorsCount, this.deletedErrorsCount, this.expectedPostProcessedRecordsNumber, this.postProcessedRecordsCount, this.definition);
        }

        public String toString() {
            return "TaskInfo.TaskInfoBuilder(id=" + this.id + ", topologyName=" + this.topologyName + ", state=" + this.state + ", stateDescription=" + this.stateDescription + ", sentTimestamp=" + this.sentTimestamp + ", startTimestamp=" + this.startTimestamp + ", finishTimestamp=" + this.finishTimestamp + ", expectedRecordsNumber=" + this.expectedRecordsNumber + ", processedRecordsCount=" + this.processedRecordsCount + ", ignoredRecordsCount=" + this.ignoredRecordsCount + ", deletedRecordsCount=" + this.deletedRecordsCount + ", processedErrorsCount=" + this.processedErrorsCount + ", deletedErrorsCount=" + this.deletedErrorsCount + ", expectedPostProcessedRecordsNumber=" + this.expectedPostProcessedRecordsNumber + ", postProcessedRecordsCount=" + this.postProcessedRecordsCount + ", definition=" + this.definition + ")";
        }
    }
}

