/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model;

import eu.europeana.cloud.common.utils.DateAdapter;
import eu.europeana.cloud.common.utils.Tags;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Revision
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String revisionName;
    private String revisionProviderId;
    @XmlElement(name="creationTimeStamp", required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date creationTimeStamp;
    boolean deleted;

    public Revision(String revisionName, String providerId) {
        this(revisionName, providerId, new Date(), false);
    }

    public Revision(String revisionName, String providerId, Date creationTimeStamp) {
        this(revisionName, providerId, creationTimeStamp, false);
    }

    public Revision(Revision revision) {
        this(revision.getRevisionName(), revision.getRevisionProviderId(), revision.getCreationTimeStamp(), revision.isDeleted());
    }

    public static Revision fromParams(String revisionName, String revisionProviderId, String tag) {
        Revision revision = new Revision(revisionName, revisionProviderId);
        revision.setRevisionTags(revision, new HashSet<String>(List.of(tag)));
        return revision;
    }

    public static Revision fromParams(String revisionName, String revisionProviderId, Set<String> tags) {
        Revision revision = new Revision(revisionName, revisionProviderId);
        revision.setRevisionTags(revision, tags);
        return revision;
    }

    private void setRevisionTags(Revision revision, Set<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        if (tags.contains(Tags.DELETED.getTag())) {
            revision.setDeleted(true);
        }
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public String getRevisionProviderId() {
        return this.revisionProviderId;
    }

    public Date getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setRevisionName(String revisionName) {
        this.revisionName = revisionName;
    }

    public void setRevisionProviderId(String revisionProviderId) {
        this.revisionProviderId = revisionProviderId;
    }

    public void setCreationTimeStamp(Date creationTimeStamp) {
        this.creationTimeStamp = creationTimeStamp;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$revisionName = this.getRevisionName();
        String other$revisionName = other.getRevisionName();
        if (this$revisionName == null ? other$revisionName != null : !this$revisionName.equals(other$revisionName)) {
            return false;
        }
        String this$revisionProviderId = this.getRevisionProviderId();
        String other$revisionProviderId = other.getRevisionProviderId();
        if (this$revisionProviderId == null ? other$revisionProviderId != null : !this$revisionProviderId.equals(other$revisionProviderId)) {
            return false;
        }
        Date this$creationTimeStamp = this.getCreationTimeStamp();
        Date other$creationTimeStamp = other.getCreationTimeStamp();
        if (this$creationTimeStamp == null ? other$creationTimeStamp != null : !((Object)this$creationTimeStamp).equals(other$creationTimeStamp)) {
            return false;
        }
        return this.isDeleted() == other.isDeleted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Revision;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $revisionName = this.getRevisionName();
        result = result * 59 + ($revisionName == null ? 43 : $revisionName.hashCode());
        String $revisionProviderId = this.getRevisionProviderId();
        result = result * 59 + ($revisionProviderId == null ? 43 : $revisionProviderId.hashCode());
        Date $creationTimeStamp = this.getCreationTimeStamp();
        result = result * 59 + ($creationTimeStamp == null ? 43 : ((Object)$creationTimeStamp).hashCode());
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Revision(revisionName=" + this.getRevisionName() + ", revisionProviderId=" + this.getRevisionProviderId() + ", creationTimeStamp=" + this.getCreationTimeStamp() + ", deleted=" + this.isDeleted() + ")";
    }

    public Revision() {
    }

    public Revision(String revisionName, String revisionProviderId, Date creationTimeStamp, boolean deleted) {
        this.revisionName = revisionName;
        this.revisionProviderId = revisionProviderId;
        this.creationTimeStamp = creationTimeStamp;
        this.deleted = deleted;
    }
}

