/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private String[] patterns = new String[0];
    private String[] excludedPatterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        Assert.notEmpty(patterns, "'patterns' must not be empty");
        this.patterns = new String[patterns.length];
        int i = 0;
        while (i < patterns.length) {
            this.patterns[i] = StringUtils.trimWhitespace(patterns[i]);
            ++i;
        }
        this.initPatternRepresentation(this.patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setExcludedPattern(String excludedPattern) {
        this.setExcludedPatterns(new String[]{excludedPattern});
    }

    public void setExcludedPatterns(String[] excludedPatterns) {
        Assert.notEmpty(excludedPatterns, "'excludedPatterns' must not be empty");
        this.excludedPatterns = new String[excludedPatterns.length];
        int i = 0;
        while (i < excludedPatterns.length) {
            this.excludedPatterns[i] = StringUtils.trimWhitespace(excludedPatterns[i]);
            ++i;
        }
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }

    public String[] getExcludedPatterns() {
        return this.excludedPatterns;
    }

    public boolean matches(Method method, Class targetClass) {
        return targetClass != null && this.matchesPattern(String.valueOf(targetClass.getName()) + "." + method.getName()) || this.matchesPattern(String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName());
    }

    protected boolean matchesPattern(String signatureString) {
        int i = 0;
        while (i < this.patterns.length) {
            boolean matched = this.matches(signatureString, i);
            if (matched) {
                int j = 0;
                while (j < this.excludedPatterns.length) {
                    boolean excluded = this.matchesExclusion(signatureString, j);
                    if (excluded) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract void initExcludedPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    protected abstract boolean matchesExclusion(String var1, int var2);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractRegexpMethodPointcut)) {
            return false;
        }
        AbstractRegexpMethodPointcut otherPointcut = (AbstractRegexpMethodPointcut)other;
        return Arrays.equals(this.patterns, otherPointcut.patterns) && Arrays.equals(this.excludedPatterns, otherPointcut.excludedPatterns);
    }

    public int hashCode() {
        int result = 27;
        String[] stringArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            result = 13 * result + pattern.hashCode();
            ++n2;
        }
        stringArray = this.excludedPatterns;
        n = this.excludedPatterns.length;
        n2 = 0;
        while (n2 < n) {
            String excludedPattern = stringArray[n2];
            result = 13 * result + excludedPattern.hashCode();
            ++n2;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": patterns " + ObjectUtils.nullSafeToString(this.patterns) + ", excluded patterns " + ObjectUtils.nullSafeToString(this.excludedPatterns);
    }
}

