/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps;

import java.io.Serializable;
import java.util.Date;

public class Harvest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String metadataPrefix;
    private Date from;
    private Date until;
    private String oaiSetSpec;

    Harvest(String url, String metadataPrefix, Date from, Date until, String oaiSetSpec) {
        this.url = url;
        this.metadataPrefix = metadataPrefix;
        this.from = from;
        this.until = until;
        this.oaiSetSpec = oaiSetSpec;
    }

    public static HarvestBuilder builder() {
        return new HarvestBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getUntil() {
        return this.until;
    }

    public String getOaiSetSpec() {
        return this.oaiSetSpec;
    }

    public String toString() {
        return "Harvest(url=" + this.getUrl() + ", metadataPrefix=" + this.getMetadataPrefix() + ", from=" + this.getFrom() + ", until=" + this.getUntil() + ", oaiSetSpec=" + this.getOaiSetSpec() + ")";
    }

    public static class HarvestBuilder {
        private String url;
        private String metadataPrefix;
        private Date from;
        private Date until;
        private String oaiSetSpec;

        HarvestBuilder() {
        }

        public HarvestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HarvestBuilder metadataPrefix(String metadataPrefix) {
            this.metadataPrefix = metadataPrefix;
            return this;
        }

        public HarvestBuilder from(Date from) {
            this.from = from;
            return this;
        }

        public HarvestBuilder until(Date until) {
            this.until = until;
            return this;
        }

        public HarvestBuilder oaiSetSpec(String oaiSetSpec) {
            this.oaiSetSpec = oaiSetSpec;
            return this;
        }

        public Harvest build() {
            return new Harvest(this.url, this.metadataPrefix, this.from, this.until, this.oaiSetSpec);
        }

        public String toString() {
            return "Harvest.HarvestBuilder(url=" + this.url + ", metadataPrefix=" + this.metadataPrefix + ", from=" + this.from + ", until=" + this.until + ", oaiSetSpec=" + this.oaiSetSpec + ")";
        }
    }
}

