/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.platform.server.NoServerPlatformDetector;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;
import org.eclipse.persistence.platform.server.was.WebSpherePlatformDetector;
import org.eclipse.persistence.platform.server.wls.WebLogicPlatformDetector;

public class ServerPlatformUtils {
    private static final List<ServerPlatformDetector> PLATFORMS = new ArrayList<ServerPlatformDetector>(Arrays.asList(new NoServerPlatformDetector(), new WebSpherePlatformDetector(), new WebLogicPlatformDetector()));
    private static final String UNKNOWN_MARKER = "UNKNOWN";
    private static String SERVER_PLATFORM_CLS;

    public static String detectServerPlatform(AbstractSession session) {
        if (SERVER_PLATFORM_CLS == null) {
            for (ServerPlatformDetector server : PLATFORMS) {
                String res = server.checkPlatform();
                if (res == null) continue;
                SERVER_PLATFORM_CLS = PropertiesHandler.getPropertyValue("eclipselink.target-server", res);
                break;
            }
            if (SERVER_PLATFORM_CLS == null) {
                SERVER_PLATFORM_CLS = UNKNOWN_MARKER;
            }
        }
        if (SERVER_PLATFORM_CLS == UNKNOWN_MARKER) {
            return null;
        }
        session.log(5, "server", "detect_server_platform", SERVER_PLATFORM_CLS);
        return SERVER_PLATFORM_CLS;
    }
}

