/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.utils;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final FastDateFormat FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", TimeZone.getTimeZone("UTC"));

    public String marshal(Date date) {
        if (date == null) {
            throw new RuntimeException("The revision creation Date shouldn't be null");
        }
        return FORMATTER.format(date);
    }

    public Date unmarshal(String stringDate) throws ParseException {
        if (stringDate == null || stringDate.isEmpty()) {
            return null;
        }
        try {
            Date date = (Date)FORMATTER.parseObject(stringDate);
            if (date == null) {
                throw new ParseException("Cannot parse the date. The accepted date format is yyyy-MM-dd'T'HH:mm:ss.SSSXXX", 0);
            }
            return date;
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage() + ". The accepted date format is " + FORMAT, e.getErrorOffset());
        }
    }
}

