/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class OAIPMHHarvestingDetails
implements Serializable {
    private Set<String> schemas;
    private Set<String> excludedSchemas;
    private Set<String> sets;
    private Set<String> excludedSets;
    private Date dateFrom;
    private Date dateUntil;
    private String granularity;

    public OAIPMHHarvestingDetails() {
    }

    public OAIPMHHarvestingDetails(String schema) {
        this.schemas = new HashSet<String>();
        this.schemas.add(schema);
    }

    public OAIPMHHarvestingDetails(Set<String> schemas, Set<String> sets, Date dateFrom, Date dateUntil, String granularity) {
        this.schemas = schemas;
        this.sets = sets;
        this.dateFrom = dateFrom;
        this.dateUntil = dateUntil;
        this.granularity = granularity;
    }

    public OAIPMHHarvestingDetails(Set<String> schemas, Set<String> excludedSchemas, Set<String> sets, Set<String> excludeSets, Date dateFrom, Date dateUntil, String granularity) {
        this(schemas, sets, dateFrom, dateUntil, granularity);
        this.excludedSchemas = excludedSchemas;
        this.excludedSets = excludeSets;
    }

    @JsonIgnore
    public String getSchema() {
        if (this.schemas == null || this.schemas.isEmpty()) {
            return null;
        }
        return this.schemas.iterator().next();
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public Set<String> getExcludedSchemas() {
        return this.excludedSchemas;
    }

    @JsonIgnore
    public String getSet() {
        if (this.sets == null || this.sets.isEmpty()) {
            return null;
        }
        return this.sets.iterator().next();
    }

    public Set<String> getSets() {
        return this.sets;
    }

    public Set<String> getExcludedSets() {
        return this.excludedSets;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateUntil() {
        return this.dateUntil;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setDateUntil(Date dateUntil) {
        this.dateUntil = dateUntil;
    }

    public void setSchemas(Set<String> schemas) {
        this.schemas = schemas;
    }

    public void setExcludedSchemas(Set<String> excludedSchemas) {
        this.excludedSchemas = excludedSchemas;
    }

    public void setSets(Set<String> sets) {
        this.sets = sets;
    }

    public void setExcludedSets(Set<String> excludeSets) {
        this.excludedSets = excludeSets;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAIPMHHarvestingDetails)) {
            return false;
        }
        OAIPMHHarvestingDetails that = (OAIPMHHarvestingDetails)o;
        return Objects.equal(this.schemas, that.schemas) && Objects.equal(this.excludedSchemas, that.excludedSchemas) && Objects.equal(this.sets, that.sets) && Objects.equal(this.excludedSets, that.excludedSets) && Objects.equal((Object)this.dateFrom, (Object)that.dateFrom) && Objects.equal((Object)this.dateUntil, (Object)that.dateUntil);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schemas, this.excludedSchemas, this.sets, this.excludedSets, this.dateFrom, this.dateUntil, this.granularity});
    }

    public String toString() {
        return "OAIPMHHarvestingDetails{schemas=" + this.schemas + ", excludedSchemas=" + this.excludedSchemas + ", sets=" + this.sets + ", excludedSets=" + this.excludedSets + ", dateFrom=" + this.dateFrom + ", dateUntil=" + this.dateUntil + ", granularity=" + this.granularity + '}';
    }
}

