/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.PermissionCacheOptimizer;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclPermissionCacheOptimizer
implements PermissionCacheOptimizer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AclService aclService;
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private ObjectIdentityRetrievalStrategy oidRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();

    public AclPermissionCacheOptimizer(AclService aclService) {
        this.aclService = aclService;
    }

    @Override
    public void cachePermissionsFor(Authentication authentication, Collection<?> objects) {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<ObjectIdentity> oidsToCache = new ArrayList<ObjectIdentity>(objects.size());
        for (Object domainObject : objects) {
            if (domainObject == null) continue;
            ObjectIdentity oid = this.oidRetrievalStrategy.getObjectIdentity(domainObject);
            oidsToCache.add(oid);
        }
        List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Eagerly loading Acls for " + oidsToCache.size() + " objects"));
        }
        this.aclService.readAclsById(oidsToCache, sids);
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        this.oidRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }
}

