/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ReferenceMapping
extends ObjectReferenceMapping {
    protected DatabaseField field;

    public ReferenceMapping() {
        this.setWeight(WEIGHT_AGGREGATE);
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        if (policy.shouldValidateExample()) {
            throw QueryException.unsupportedMappingQueryByExample(queryObject.getClass().getName(), this);
        }
        return null;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    @Override
    public Expression getJoinCriteria(ObjectExpression context, Expression base) {
        return null;
    }

    @Override
    public boolean hasConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        this.setReferenceDescriptor(session.getDescriptor(this.getReferenceClass()));
        if (this.referenceDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)this.getField();
        field.setSqlType(2006);
        if (this.referenceDescriptor instanceof ObjectRelationalDataTypeDescriptor) {
            field.setSqlTypeName(((ObjectRelationalDataTypeDescriptor)this.referenceDescriptor).getStructureName());
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        this.getDescriptor().setIsNativeConnectionRequired(true);
    }

    @Override
    public boolean isReferenceMapping() {
        return true;
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object == null) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            insertQuery.setIsExecutionClone(true);
            insertQuery.setObject(object);
            insertQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(insertQuery);
        } else {
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objectInDatabase;
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (objectInDatabase = this.readPrivateOwnedForObject(query)) != null) {
            query.setProperty(this, objectInDatabase);
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object != null) {
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    protected void setField(DatabaseField field) {
        this.field = field;
    }

    public void setFieldName(String fieldName) {
        this.setField(new ObjectRelationalDatabaseField(fieldName));
    }

    @Override
    public void setReferenceClass(Class referenceClass) {
        this.referenceClass = referenceClass;
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        if (this.descriptor.getCachePolicy().isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object result = null;
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    return this.getAttributeValueFromObject(cached);
                }
                return result;
            }
            if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return this.indirectionPolicy.buildIndirectObject(new ValueHolder(null));
            }
        }
        AbstractRecord targetRow = null;
        if (row.hasSopObject()) {
            Object sopAttributeValue = this.getAttributeValueFromObject(row.getSopObject());
            if (sopAttributeValue == null) {
                return this.indirectionPolicy.nullValueFromRow();
            }
            Object sopRealAttributeValue = this.getIndirectionPolicy().getRealAttributeValueFromObject(row.getSopObject(), sopAttributeValue);
            if (sopRealAttributeValue == null) {
                return sopAttributeValue;
            }
            targetRow = new DatabaseRecord(0);
            targetRow.setSopObject(sopRealAttributeValue);
            return this.getReferenceDescriptor().getObjectBuilder().buildObject(query, targetRow, null);
        }
        Ref ref = (Ref)row.get(this.getField());
        if (ref == null) {
            return null;
        }
        try {
            try {
                ((DatabaseAccessor)executionSession.getAccessor()).incrementCallCount(executionSession);
                Connection connection = ((DatabaseAccessor)executionSession.getAccessor()).getConnection();
                Struct struct = (Struct)executionSession.getPlatform().getRefValue(ref, executionSession, connection);
                targetRow = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).buildRowFromStructure(struct);
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception, executionSession, false);
            }
        }
        finally {
            ((DatabaseAccessor)executionSession.getAccessor()).decrementCallCount();
        }
        return this.getReferenceDescriptor().getObjectBuilder().buildObject(query, targetRow, joinManager);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord record, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeFromObjectIntoRowInternal(object, record, session, false);
    }

    public void writeFromObjectIntoRowInternal(Object object, AbstractRecord record, AbstractSession session, boolean shouldIgnoreNull) {
        Object referenceObject = this.getRealAttributeValueFromObject(object, session);
        if (referenceObject == null) {
            if (!shouldIgnoreNull) {
                record.put(this.getField(), (Object)null);
            }
            return;
        }
        Ref ref = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(referenceObject, session);
        record.put(this.getField(), (Object)ref);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet changeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        Object referenceObject = changeSet.getUnitOfWorkClone();
        if (referenceObject == null) {
            return;
        }
        Ref ref = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(referenceObject, session);
        record.put(this.getField(), (Object)ref);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getField().isNullable()) {
            record.put(this.getField(), (Object)null);
        } else {
            this.writeFromObjectIntoRowInternal(object, record, session, false);
        }
    }

    @Override
    public void writeFromObjectIntoRowForUpdateAfterShallowInsert(Object object, AbstractRecord record, AbstractSession session, DatabaseTable table) {
        if (this.isReadOnly) {
            return;
        }
        if (!this.getField().getTable().equals(table) || !this.getField().isNullable()) {
            return;
        }
        this.writeFromObjectIntoRowInternal(object, record, session, true);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }
}

