/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class WebSphereNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_ADAPTER_CONNECTION_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
    private static final String JDBC_ADAPTER_UTIL_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcUtil";
    private Class webSphere5ConnectionClass;
    private Method webSphere5NativeConnectionMethod;

    public WebSphereNativeJdbcExtractor() {
        try {
            this.webSphere5ConnectionClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_CONNECTION_NAME_5);
            Class<?> jdbcAdapterUtilClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_UTIL_NAME_5);
            this.webSphere5NativeConnectionMethod = jdbcAdapterUtilClass.getMethod("getNativeConnection", this.webSphere5ConnectionClass);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize WebSphereNativeJdbcExtractor because WebSphere API classes are not available: " + ex);
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.webSphere5ConnectionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeJdbcMethod(this.webSphere5NativeConnectionMethod, null, con);
        }
        return con;
    }
}

