/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.dps.rest;

import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.exception.DPSExceptionProvider;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.cloud.service.dps.metis.indexing.DataSetCleanerParameters;
import java.net.URI;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpsClient {
    private static final String ERROR = "error";
    private static final String IDS_COUNT = "idsCount";
    private static final Logger LOGGER = LoggerFactory.getLogger(DpsClient.class);
    private static final String TOPOLOGY_NAME = "TopologyName";
    private static final String TASK_ID = "TaskId";
    private static final String TASKS_URL = "/{TopologyName}/tasks";
    private static final String PERMIT_TOPOLOGY_URL = "/{TopologyName}/permit";
    private static final String TASK_URL = "/{TopologyName}/tasks/{TaskId}";
    private static final String REPORTS_RESOURCE = "reports";
    private static final String STATISTICS_RESOURCE = "statistics";
    private static final String KILL_TASK = "kill";
    private static final String TASK_PROGRESS_URL = "/{TopologyName}/tasks/{TaskId}/progress";
    private static final String TASK_CLEAN_DATASET_URL = "/{TopologyName}/tasks/{TaskId}/cleaner";
    private static final String DETAILED_TASK_REPORT_URL = "/{TopologyName}/tasks/{TaskId}/reports/details";
    private static final String ERRORS_TASK_REPORT_URL = "/{TopologyName}/tasks/{TaskId}/reports/errors";
    private static final String STATISTICS_REPORT_URL = "/{TopologyName}/tasks/{TaskId}/statistics";
    private static final String KILL_TASK_URL = "/{TopologyName}/tasks/{TaskId}/kill";
    private static final String ELEMENT_REPORT = "/{TopologyName}/tasks/{TaskId}/reports/element";
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MILLIS = 20000;
    private static final int DEFAULT_READ_TIMEOUT_IN_MILLIS = 60000;
    private final String dpsUrl;
    private final Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();

    public DpsClient(String dpsUrl, String username, String password, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this.client.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
        this.client.property("jersey.config.client.connectTimeout", (Object)connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", (Object)readTimeoutInMillis);
        this.dpsUrl = dpsUrl;
    }

    public DpsClient(String dpsUrl, String username, String password) {
        this(dpsUrl, username, password, 20000, 60000);
    }

    public DpsClient(String dpsUrl, int connectTimeoutInMillis, int readTimeoutInMillis) {
        this.client.property("jersey.config.client.connectTimeout", (Object)connectTimeoutInMillis);
        this.client.property("jersey.config.client.readTimeout", (Object)readTimeoutInMillis);
        this.dpsUrl = dpsUrl;
    }

    public DpsClient(String dpsUrl) {
        this(dpsUrl, 20000, 60000);
    }

    public long submitTask(DpsTask task, String topologyName) throws DpsException {
        Response resp;
        block3: {
            resp = null;
            try {
                resp = this.client.target(this.dpsUrl).path(TASKS_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).request().post(Entity.json((Object)task));
                if (resp.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                long l = this.getTaskId(resp.getLocation());
                this.closeResponse(resp);
                return l;
            }
            catch (Throwable throwable) {
                this.closeResponse(resp);
                throw throwable;
            }
        }
        LOGGER.error("Submit Task Was not successful");
        throw this.handleException(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanMetisIndexingDataset(String topologyName, long taskId, DataSetCleanerParameters dataSetCleanerParameters) throws DpsException {
        Response resp = null;
        try {
            resp = this.client.target(this.dpsUrl).path(TASK_CLEAN_DATASET_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).request().post(Entity.json((Object)dataSetCleanerParameters));
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                LOGGER.error("Cleaning a dataset was not successful");
                throw this.handleException(resp);
            }
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanMetisIndexingDataset(String topologyName, long taskId, DataSetCleanerParameters dataSetCleanerParameters, String key, String value) throws DpsException {
        Response resp = null;
        try {
            resp = this.client.target(this.dpsUrl).path(TASK_CLEAN_DATASET_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).request().header(key, (Object)value).post(Entity.json((Object)dataSetCleanerParameters));
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                LOGGER.error("Cleaning a dataset was not successful");
                throw this.handleException(resp);
            }
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    public Response.StatusType topologyPermit(String topologyName, String username) throws DpsException {
        Response resp;
        block3: {
            Form form = new Form();
            form.param("username", username);
            resp = null;
            try {
                resp = this.client.target(this.dpsUrl).path(PERMIT_TOPOLOGY_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).request().post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                if (resp.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                Response.StatusType statusType = resp.getStatusInfo();
                this.closeResponse(resp);
                return statusType;
            }
            catch (Throwable throwable) {
                this.closeResponse(resp);
                throw throwable;
            }
        }
        LOGGER.error("Granting permission was not successful");
        throw this.handleException(resp);
    }

    public TaskInfo getTaskProgress(String topologyName, long taskId) throws DpsException {
        Response response;
        block3: {
            response = null;
            try {
                response = this.client.target(this.dpsUrl).path(TASK_PROGRESS_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).request().get();
                if (response.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                TaskInfo taskInfo = (TaskInfo)response.readEntity(TaskInfo.class);
                this.closeResponse(response);
                return taskInfo;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        LOGGER.error("Task progress cannot be read");
        throw this.handleException(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubTaskInfo> getDetailedTaskReport(String topologyName, long taskId) throws DpsException {
        Response response = null;
        try {
            response = this.client.target(this.dpsUrl).path(DETAILED_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).request().get();
            List<SubTaskInfo> list = this.handleResponse(response);
            this.closeResponse(response);
            return list;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubTaskInfo> getDetailedTaskReportBetweenChunks(String topologyName, long taskId, int from, int to) throws DpsException {
        Response getResponse = null;
        try {
            getResponse = this.client.target(this.dpsUrl).path(DETAILED_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).queryParam("from", new Object[]{from}).queryParam("to", new Object[]{to}).request().get();
            List<SubTaskInfo> list = this.handleResponse(getResponse);
            this.closeResponse(getResponse);
            return list;
        }
        catch (Throwable throwable) {
            this.closeResponse(getResponse);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeReport> getElementReport(String topologyName, long taskId, String elementPath) throws DpsException {
        Response getResponse = null;
        try {
            getResponse = this.client.target(this.dpsUrl).path(ELEMENT_REPORT).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).queryParam("path", new Object[]{elementPath}).request().get();
            List<NodeReport> list = this.handleElementReportResponse(getResponse);
            this.closeResponse(getResponse);
            return list;
        }
        catch (Throwable throwable) {
            this.closeResponse(getResponse);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskErrorsInfo getTaskErrorsReport(String topologyName, long taskId, String error, int idsCount) throws DpsException {
        Response response = null;
        try {
            response = this.client.target(this.dpsUrl).path(ERRORS_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).queryParam(ERROR, new Object[]{error}).queryParam(IDS_COUNT, new Object[]{idsCount}).request().get();
            TaskErrorsInfo taskErrorsInfo = this.handleErrorResponse(response);
            this.closeResponse(response);
            return taskErrorsInfo;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfErrorReportExists(String topologyName, long taskId) {
        Response response = null;
        try {
            response = this.client.target(this.dpsUrl).path(ERRORS_TASK_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).request().head();
            boolean bl = response.getStatus() == Response.Status.OK.getStatusCode();
            this.closeResponse(response);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
    }

    public StatisticsReport getTaskStatisticsReport(String topologyName, long taskId) throws DpsException {
        Response response;
        block3: {
            response = null;
            try {
                response = this.client.target(this.dpsUrl).path(STATISTICS_REPORT_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId).request().get();
                if (response.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                StatisticsReport statisticsReport = (StatisticsReport)response.readEntity(StatisticsReport.class);
                this.closeResponse(response);
                return statisticsReport;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        LOGGER.error("Task statistics report cannot be read");
        throw this.handleException(response);
    }

    public String killTask(String topologyName, long taskId, String info) throws DpsException {
        Response response;
        block4: {
            response = null;
            try {
                WebTarget webTarget = this.client.target(this.dpsUrl).path(KILL_TASK_URL).resolveTemplate(TOPOLOGY_NAME, (Object)topologyName).resolveTemplate(TASK_ID, (Object)taskId);
                if (info != null) {
                    webTarget = webTarget.queryParam("info", new Object[]{info});
                }
                if ((response = webTarget.request().post(null)).getStatus() != Response.Status.OK.getStatusCode()) break block4;
                String string = (String)response.readEntity(String.class);
                this.closeResponse(response);
                return string;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        LOGGER.error("Task Can't be killed");
        throw this.handleException(response);
    }

    public void close() {
        this.client.close();
    }

    private long getTaskId(URI uri) {
        String[] elements = uri.getRawPath().split("/");
        return Long.parseLong(elements[elements.length - 1]);
    }

    private List<NodeReport> handleElementReportResponse(Response response) throws DpsException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (List)response.readEntity((GenericType)new GenericType<List<NodeReport>>(){});
        }
        throw this.handleException(response);
    }

    private List<SubTaskInfo> handleResponse(Response response) throws DpsException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (List)response.readEntity((GenericType)new GenericType<List<SubTaskInfo>>(){});
        }
        throw this.handleException(response);
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    private TaskErrorsInfo handleErrorResponse(Response response) throws DpsException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (TaskErrorsInfo)response.readEntity(TaskErrorsInfo.class);
        }
        LOGGER.error("Task error report cannot be read");
        throw this.handleException(response);
    }

    private DpsException handleException(Response response) {
        try {
            DpsException dpsException;
            if (response.getStatus() == 503) {
                dpsException = new DpsException("Service unavailable", (Exception)new ServiceUnavailableException());
            } else if (response.getStatus() == 404) {
                dpsException = new DpsException("Endpoint not found", (Exception)new NotFoundException());
            } else {
                ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
                dpsException = DPSExceptionProvider.generateException((ErrorInfo)errorInfo);
            }
            return dpsException;
        }
        catch (Exception e) {
            return new DpsException("Could not identify exception", e);
        }
    }

    protected void finalize() throws Throwable {
        this.client.close();
    }
}

