/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.converters;

import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.Harvest;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.converters.GenericOneToManyConverter;
import java.util.ArrayList;
import java.util.List;

public class DpsTaskToHarvestConverter
implements GenericOneToManyConverter<DpsTask, Harvest> {
    @Override
    public List<Harvest> from(DpsTask dpsTask) {
        ArrayList<Harvest> harvestsToByExecuted = new ArrayList<Harvest>();
        for (String repoUrl : dpsTask.getDataEntry(InputDataType.REPOSITORY_URLS)) {
            for (String schema : dpsTask.getHarvestingDetails().getSchemas()) {
                if (dpsTask.getHarvestingDetails().getSets() != null && dpsTask.getHarvestingDetails().getSets().size() > 0) {
                    for (String set : dpsTask.getHarvestingDetails().getSets()) {
                        Harvest h = Harvest.builder().url(repoUrl).from(dpsTask.getHarvestingDetails().getDateFrom()).until(dpsTask.getHarvestingDetails().getDateUntil()).oaiSetSpec(set).metadataPrefix(schema).build();
                        harvestsToByExecuted.add(h);
                    }
                    continue;
                }
                Harvest h = Harvest.builder().url(repoUrl).from(dpsTask.getHarvestingDetails().getDateFrom()).until(dpsTask.getHarvestingDetails().getDateUntil()).metadataPrefix(schema).build();
                harvestsToByExecuted.add(h);
            }
        }
        return harvestsToByExecuted;
    }

    @Override
    public DpsTask to(Harvest harvest) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

