/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model;

import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Revision;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Representation {
    private String cloudId;
    private String representationName;
    private String version;
    private URI allVersionsUri;
    private URI uri;
    private String dataProvider;
    private List<File> files = new ArrayList<File>(0);
    private Date creationDate;
    private boolean persistent;
    private List<Revision> revisions = new ArrayList<Revision>(0);

    public List<Revision> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(List<Revision> revisions) {
        this.revisions = revisions;
    }

    public Representation() {
    }

    public Representation(String cloudId, String representationName, String version, URI allVersionsUri, URI uri, String dataProvider, List<File> files, List<Revision> revisions, boolean persistent, Date creationDate) {
        this.cloudId = cloudId;
        this.representationName = representationName;
        this.version = version;
        this.allVersionsUri = allVersionsUri;
        this.uri = uri;
        this.dataProvider = dataProvider;
        this.files = files;
        this.revisions = revisions;
        this.persistent = persistent;
        this.creationDate = creationDate != null ? creationDate : null;
    }

    public Representation(Representation representation) {
        this(representation.getCloudId(), representation.getRepresentationName(), representation.getVersion(), representation.getAllVersionsUri(), representation.getUri(), representation.getDataProvider(), Representation.cloneFiles(representation), Representation.cloneRevisions(representation), representation.isPersistent(), representation.getCreationDate());
    }

    private static List<File> cloneFiles(Representation representation) {
        ArrayList<File> files = new ArrayList<File>(representation.getFiles().size());
        for (File file : representation.getFiles()) {
            files.add(new File(file));
        }
        return files;
    }

    private static List<Revision> cloneRevisions(Representation representation) {
        List<Revision> revisions = representation.getRevisions();
        if (revisions == null || revisions.isEmpty()) {
            return new ArrayList<Revision>();
        }
        ArrayList<Revision> clonedRevisions = new ArrayList<Revision>(revisions.size());
        for (Revision revision : revisions) {
            clonedRevisions.add(new Revision(revision));
        }
        return clonedRevisions;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getRepresentationName() {
        return this.representationName;
    }

    public void setRepresentationName(String representationName) {
        this.representationName = representationName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(String dataProvider) {
        this.dataProvider = dataProvider;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public URI getAllVersionsUri() {
        return this.allVersionsUri;
    }

    public void setAllVersionsUri(URI allVersionsUri) {
        this.allVersionsUri = allVersionsUri;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI selfUri) {
        this.uri = selfUri;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? creationDate : null;
    }

    public String getId() {
        return this.getACLId();
    }

    private String getACLId() {
        return this.getCloudId() + "/" + this.getRepresentationName() + "/" + this.getVersion();
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.cloudId);
        hash = 37 * hash + Objects.hashCode(this.representationName);
        hash = 37 * hash + Objects.hashCode(this.version);
        hash = 37 * hash + Objects.hashCode(this.dataProvider);
        hash = 37 * hash + Objects.hashCode(this.files);
        hash = 37 * hash + Objects.hashCode(this.revisions);
        hash = 37 * hash + Objects.hashCode(this.creationDate);
        hash = 37 * hash + (this.persistent ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Representation other = (Representation)obj;
        if (!Objects.equals(this.cloudId, other.cloudId)) {
            return false;
        }
        if (!Objects.equals(this.representationName, other.representationName)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.dataProvider, other.dataProvider)) {
            return false;
        }
        if (!Objects.equals(this.files, other.files)) {
            return false;
        }
        if (!Objects.equals(this.revisions, other.revisions)) {
            return false;
        }
        if (!Objects.equals(this.creationDate.toString(), other.creationDate.toString())) {
            return false;
        }
        return this.persistent == other.persistent;
    }

    public String toString() {
        return "Representation{cloudId=" + this.cloudId + ", representationName=" + this.representationName + ", version=" + this.version + ", dataProvider=" + this.dataProvider + ", files=" + this.files + ", revisions=" + this.revisions + ", creationDate=" + this.creationDate + ", persistent=" + this.persistent + '}';
    }
}

