/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;

public final class JavaVersion {
    public static final char SEPARATOR = '.';
    public static final char PATCH_SEPARATOR = '_';
    private static final String VM_VERSION_PROPERTY = "java.version";
    private static final String VM_VERSION_PATTERN = "[^0-9]*([0-9]+)\\.([0-9]+)(?:\\.([0-9]+)(?:[-_\\.]([0-9]+)){0,1}){0,1}[^0-9]*";
    private static final int VM_MIN_VERSION_TOKENS = 2;
    private final int major;
    private final int minor;
    private final int revision;
    private final int patch;

    public static String vmVersionString() {
        return System.getProperty(VM_VERSION_PROPERTY);
    }

    public static JavaVersion vmVersion() {
        int groupCount;
        String version = JavaVersion.vmVersionString();
        Pattern pattern = Pattern.compile(VM_VERSION_PATTERN);
        Matcher matcher = pattern.matcher(version);
        int major = 0;
        int minor = 0;
        int revision = 0;
        int patch = 0;
        if (matcher.find() && (groupCount = matcher.groupCount()) >= 2) {
            major = Integer.parseInt(matcher.group(1));
            minor = Integer.parseInt(matcher.group(2));
            revision = groupCount > 2 && matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
            patch = groupCount > 3 && matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
        }
        return new JavaVersion(major, minor, revision, patch);
    }

    public JavaVersion(int major, int minor, int revision, int patch) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.patch = patch;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getRevision() {
        return this.revision;
    }

    public final int getPatch() {
        return this.patch;
    }

    public final int comapreTo(JavaVersion version) {
        return this.major > version.major ? 1 : (this.major < version.major ? -1 : (this.minor > version.minor ? 1 : (this.minor < version.minor ? -1 : (this.revision > version.revision ? 1 : (this.revision < version.revision ? -1 : (this.patch > version.patch ? 1 : (this.patch < version.patch ? -1 : 0)))))));
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(12);
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        sb.append('.');
        sb.append(this.revision);
        sb.append('_');
        sb.append(this.patch);
        return sb.toString();
    }

    public final JavaSEPlatform toPlatform() {
        return JavaSEPlatform.toValue(this.major, this.minor);
    }
}

