/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.dps.rest;

import eu.europeana.cloud.service.dps.DpsTask;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpsClient {
    private Logger LOGGER = LoggerFactory.getLogger(DpsClient.class);
    private String dpsUrl;
    private Client client = JerseyClientBuilder.newClient();
    private static final String USERNAME = "Username";
    private static final String TOPOLOGY_NAME = "TopologyName";
    private static final String TASK_ID = "TaskId";
    private static final String TASKS_URL = "/topologies/{TopologyName}/tasks";
    private static final String PERMIT_TIPOLOGY_URL = "/topologies/{TopologyName}/permit";
    private static final String TASK_URL = "/topologies/{TopologyName}/tasks/{TaskId}";
    public static final String TASK_PROGRESS_URL = "/topologies/{TopologyName}/tasks/{TaskId}/progress";
    public static final String TASK_NOTIFICATION_URL = "/topologies/{TopologyName}/tasks/{TaskId}/notification";

    public DpsClient(String dpsUrl, String username, String password) {
        this.client.register(HttpAuthenticationFeature.basic(username, password));
        this.dpsUrl = dpsUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(DpsTask task, String topologyName) {
        Response resp = null;
        try {
            resp = this.client.target(this.dpsUrl).path(TASKS_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).request().post(Entity.json(task));
            if (resp.getStatus() != Response.Status.CREATED.getStatusCode()) {
                throw new RuntimeException("submiting taks failed!!");
            }
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void topologyPermit(String topologyName, String username) {
        Form form = new Form();
        form.param("userneme", username);
        Response resp = null;
        try {
            resp = this.client.target(this.dpsUrl).path(PERMIT_TIPOLOGY_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new RuntimeException("Permit topology failed!");
            }
            this.closeResponse(resp);
        }
        catch (Throwable throwable) {
            this.closeResponse(resp);
            throw throwable;
        }
    }

    public DpsTask getTask(String topologyName, long taskId) {
        block3: {
            Response getResponse = null;
            try {
                DpsTask task;
                getResponse = this.client.target(this.dpsUrl).path(TASK_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, String.valueOf(taskId)).request().header("Accept", "application/json").get();
                if (getResponse.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                DpsTask dpsTask = task = getResponse.readEntity(DpsTask.class);
                this.closeResponse(getResponse);
                return dpsTask;
            }
            catch (Throwable throwable) {
                this.closeResponse(getResponse);
                throw throwable;
            }
        }
        throw new RuntimeException();
    }

    public String getTaskProgress(String topologyName, long taskId) {
        block3: {
            Response getResponse = null;
            try {
                String taskProgress;
                getResponse = this.client.target(this.dpsUrl).path(TASK_PROGRESS_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get();
                if (getResponse.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                String string = taskProgress = getResponse.readEntity(String.class);
                this.closeResponse(getResponse);
                return string;
            }
            catch (Throwable throwable) {
                this.closeResponse(getResponse);
                throw throwable;
            }
        }
        this.LOGGER.error("Task progress cannot be read");
        throw new RuntimeException();
    }

    public String getTaskNotification(String topologyName, long taskId) {
        block3: {
            Response getResponse = null;
            try {
                String taskProgress;
                getResponse = this.client.target(this.dpsUrl).path(TASK_NOTIFICATION_URL).resolveTemplate(TOPOLOGY_NAME, topologyName).resolveTemplate(TASK_ID, taskId).request().get();
                if (getResponse.getStatus() != Response.Status.OK.getStatusCode()) break block3;
                String string = taskProgress = getResponse.readEntity(String.class);
                this.closeResponse(getResponse);
                return string;
            }
            catch (Throwable throwable) {
                this.closeResponse(getResponse);
                throw throwable;
            }
        }
        this.LOGGER.error("Task notification cannot be read");
        throw new RuntimeException();
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }
}

