/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.classreading.AbstractRecursiveAnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RecursiveAnnotationAttributesVisitor
extends AbstractRecursiveAnnotationVisitor {
    private final String annotationType;

    public RecursiveAnnotationAttributesVisitor(String annotationType, AnnotationAttributes attributes, ClassLoader classLoader) {
        super(classLoader, attributes);
        this.annotationType = annotationType;
    }

    @Override
    public final void visitEnd() {
        try {
            Class<?> annotationClass = this.classLoader.loadClass(this.annotationType);
            this.doVisitEnd(annotationClass);
        }
        catch (ClassNotFoundException ex) {
            this.logger.debug("Failed to classload type while reading annotation metadata. This is a non-fatal error, but certain annotation metadata may be unavailable.", ex);
        }
    }

    protected void doVisitEnd(Class<?> annotationClass) {
        this.registerDefaultValues(annotationClass);
    }

    private void registerDefaultValues(Class<?> annotationClass) {
        Method[] annotationAttributes;
        for (Method annotationAttribute : annotationAttributes = annotationClass.getMethods()) {
            String attributeName = annotationAttribute.getName();
            AnnotationAttributes[] defaultValue = annotationAttribute.getDefaultValue();
            if (defaultValue == null || this.attributes.containsKey(attributeName)) continue;
            if (defaultValue instanceof Annotation) {
                defaultValue = AnnotationAttributes.fromMap(AnnotationUtils.getAnnotationAttributes((Annotation)defaultValue, false, true));
            } else if (defaultValue instanceof Annotation[]) {
                Annotation[] realAnnotations = (Annotation[])defaultValue;
                AnnotationAttributes[] mappedAnnotations = new AnnotationAttributes[realAnnotations.length];
                for (int i = 0; i < realAnnotations.length; ++i) {
                    mappedAnnotations[i] = AnnotationAttributes.fromMap(AnnotationUtils.getAnnotationAttributes(realAnnotations[i], false, true));
                }
                defaultValue = mappedAnnotations;
            }
            this.attributes.put(attributeName, defaultValue);
        }
    }
}

