/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model.dps;

import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaskInfo {
    private final long id;
    private final String topologyName;
    private int containsElements;
    private TaskState state;
    private String info;
    private List<SubTaskInfo> subtasks = new ArrayList<SubTaskInfo>();

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public TaskInfo(long id, String topologyName, TaskState state, String info) {
        this.id = id;
        this.topologyName = topologyName;
        this.state = state;
        this.info = info;
    }

    public TaskInfo(long id, String topologyName, TaskState state) {
        this(id, topologyName, state, "");
    }

    public long getId() {
        return this.id;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public int getContainsElements() {
        return this.containsElements;
    }

    public void setContainsElements(int containsElements) {
        this.containsElements = containsElements;
    }

    public List<SubTaskInfo> getSubtasks() {
        return Collections.unmodifiableList(this.subtasks);
    }

    public void addSubtask(SubTaskInfo subtask) {
        this.subtasks.add(subtask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)o;
        if (this.containsElements != taskInfo.containsElements) {
            return false;
        }
        if (this.id != taskInfo.id) {
            return false;
        }
        if (this.subtasks != null ? !this.subtasks.equals(taskInfo.subtasks) : taskInfo.subtasks != null) {
            return false;
        }
        return !(this.topologyName != null ? !this.topologyName.equals(taskInfo.topologyName) : taskInfo.topologyName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.topologyName != null ? this.topologyName.hashCode() : 0);
        result = 31 * result + this.containsElements;
        result = 31 * result + (this.subtasks != null ? this.subtasks.hashCode() : 0);
        return result;
    }
}

