/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spring.AutowiredInjectResolver;
import org.glassfish.jersey.server.spring.LocalizationMessages;
import org.jvnet.hk2.spring.bridge.api.SpringBridge;
import org.jvnet.hk2.spring.bridge.api.SpringIntoHK2Bridge;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentProvider
implements ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(SpringComponentProvider.class.getName());
    private static final String DEFAULT_CONTEXT_CONFIG_LOCATION = "applicationContext.xml";
    private static final String PARAM_CONTEXT_CONFIG_LOCATION = "contextConfigLocation";
    private volatile ServiceLocator locator;
    private volatile ApplicationContext ctx;

    @Override
    public void initialize(ServiceLocator locator) {
        ServletContext sc;
        this.locator = locator;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.CTX_LOOKUP_STARTED());
        }
        if ((sc = locator.getService(ServletContext.class, new Annotation[0])) != null) {
            this.ctx = WebApplicationContextUtils.getWebApplicationContext(sc);
        } else {
            ApplicationHandler applicationHandler = locator.getService(ApplicationHandler.class, new Annotation[0]);
            String contextConfigLocation = (String)applicationHandler.getConfiguration().getProperty(PARAM_CONTEXT_CONFIG_LOCATION);
            if (contextConfigLocation == null) {
                contextConfigLocation = DEFAULT_CONTEXT_CONFIG_LOCATION;
            }
            this.ctx = new ClassPathXmlApplicationContext(contextConfigLocation, "jersey-spring-applicationContext.xml");
        }
        if (this.ctx == null) {
            LOGGER.severe(LocalizationMessages.CTX_LOOKUP_FAILED());
            return;
        }
        LOGGER.config(LocalizationMessages.CTX_LOOKUP_SUCESSFUL());
        SpringBridge.getSpringBridge().initializeSpringBridge(locator);
        SpringIntoHK2Bridge springBridge = locator.getService(SpringIntoHK2Bridge.class, new Annotation[0]);
        springBridge.bridgeSpringBeanFactory(this.ctx);
        ServiceLocatorUtilities.addOneConstant(locator, new AutowiredInjectResolver(this.ctx));
        ServiceLocatorUtilities.addOneConstant(locator, this.ctx, "SpringContext", new Type[]{ApplicationContext.class});
        LOGGER.config(LocalizationMessages.SPRING_COMPONENT_PROVIDER_INITIALIZED());
    }

    @Override
    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (this.ctx == null) {
            return false;
        }
        if (component.isAnnotationPresent(Component.class)) {
            DynamicConfiguration c = Injections.getConfiguration(this.locator);
            String[] beanNames = this.ctx.getBeanNamesForType(component);
            if (beanNames == null || beanNames.length != 1) {
                LOGGER.severe(LocalizationMessages.NONE_OR_MULTIPLE_BEANS_AVAILABLE(component));
                return false;
            }
            String beanName = beanNames[0];
            ServiceBindingBuilder<?> bb = Injections.newFactoryBinder(new SpringManagedBeanFactory(this.ctx, this.locator, beanName));
            bb.to(component);
            Injections.addBinding(bb, c);
            c.commit();
            LOGGER.config(LocalizationMessages.BEAN_REGISTERED(beanName));
            return true;
        }
        return false;
    }

    @Override
    public void done() {
    }

    private static class SpringManagedBeanFactory
    implements Factory {
        private final ApplicationContext ctx;
        private final ServiceLocator locator;
        private final String beanName;

        private SpringManagedBeanFactory(ApplicationContext ctx, ServiceLocator locator, String beanName) {
            this.ctx = ctx;
            this.locator = locator;
            this.beanName = beanName;
        }

        public Object provide() {
            Object bean = this.ctx.getBean(this.beanName);
            this.locator.inject(bean);
            return bean;
        }

        public void dispose(Object instance) {
        }
    }
}

