/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.RuntimeResource;

class PushMatchedRuntimeResourceRouter
implements Router {
    private final RuntimeResource resource;
    private final Provider<RoutingContext> routingContext;

    private PushMatchedRuntimeResourceRouter(RuntimeResource resource, Provider<RoutingContext> routingContext) {
        this.resource = resource;
        this.routingContext = routingContext;
    }

    @Override
    public Router.Continuation apply(ContainerRequest data) {
        this.routingContext.get().pushMatchedRuntimeResource(this.resource);
        return Router.Continuation.of(data);
    }

    static class Builder {
        @Inject
        private Provider<RoutingContext> routingContext;

        Builder() {
        }

        PushMatchedRuntimeResourceRouter build(RuntimeResource runtimeResource) {
            return new PushMatchedRuntimeResourceRouter(runtimeResource, this.routingContext);
        }
    }
}

