/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json;

import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.filtering.EntityFilteringFeature;
import org.glassfish.jersey.message.filtering.SecurityEntityFilteringFeature;
import org.glassfish.jersey.moxy.internal.MoxyFilteringFeature;
import org.glassfish.jersey.moxy.json.internal.ConfigurableMoxyJsonProvider;
import org.glassfish.jersey.moxy.json.internal.FilteringMoxyJsonProvider;

public class MoxyJsonFeature
implements Feature {
    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        if (PropertiesHelper.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.disableMoxyJson", Boolean.FALSE, Boolean.class).booleanValue()) {
            return false;
        }
        int workerPriority = 7000;
        if (this.entityFilteringEnabled(config)) {
            context.register(MoxyFilteringFeature.class);
            context.register(FilteringMoxyJsonProvider.class, 7000);
        } else {
            context.register(ConfigurableMoxyJsonProvider.class, 7000);
        }
        return true;
    }

    private boolean entityFilteringEnabled(Configuration config) {
        return config.isRegistered(EntityFilteringFeature.class) || config.isRegistered(SecurityEntityFilteringFeature.class);
    }
}

