/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.internal;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBHelper;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.eclipse.persistence.jaxb.Subgraph;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.glassfish.jersey.message.filtering.spi.AbstractObjectProvider;

final class MoxyObjectProvider
extends AbstractObjectProvider<ObjectGraph> {
    private static final JAXBContext JAXB_CONTEXT;

    MoxyObjectProvider() {
    }

    @Override
    public ObjectGraph transform(org.glassfish.jersey.message.filtering.spi.ObjectGraph graph) {
        return this.createObjectGraph(graph.getEntityClass(), graph);
    }

    private ObjectGraph createObjectGraph(Class<?> entityClass, org.glassfish.jersey.message.filtering.spi.ObjectGraph objectGraph) {
        Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> subgraphs;
        ObjectGraph graph = JAXB_CONTEXT.createObjectGraph(entityClass);
        Set<String> fields = objectGraph.getFields();
        if (!fields.isEmpty()) {
            graph.addAttributeNodes(fields.toArray(new String[fields.size()]));
        }
        if (!(subgraphs = objectGraph.getSubgraphs()).isEmpty()) {
            this.createSubgraphs(graph, objectGraph.getEntityClass(), subgraphs);
        }
        return graph;
    }

    private void createSubgraphs(ObjectGraph graph, Class<?> entityClass, Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entitySubgraphs) {
        HashSet<String> processed = Sets.newHashSet();
        for (Map.Entry<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entry : entitySubgraphs.entrySet()) {
            Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> subgraphs;
            Subgraph subgraph = graph.addSubgraph(entry.getKey());
            org.glassfish.jersey.message.filtering.spi.ObjectGraph entityGraph = entry.getValue();
            Set<String> fields = entityGraph.getFields();
            if (!fields.isEmpty()) {
                subgraph.addAttributeNodes(fields.toArray(new String[fields.size()]));
            }
            if ((subgraphs = entityGraph.getSubgraphs()).isEmpty()) continue;
            Class<?> subEntityClass = entityGraph.getEntityClass();
            processed.add(this.getProcessedSubgraph(entityClass, entry.getKey(), subEntityClass));
            this.createSubgraphs(subgraph, subEntityClass, subgraphs, processed);
        }
    }

    private void createSubgraphs(Subgraph graph, Class<?> entityClass, Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entitySubgraphs, Set<String> processed) {
        for (Map.Entry<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> entry : entitySubgraphs.entrySet()) {
            Subgraph subgraph = graph.addSubgraph(entry.getKey());
            org.glassfish.jersey.message.filtering.spi.ObjectGraph entityGraph = entry.getValue();
            Set<String> fields = entityGraph.getFields();
            if (!fields.isEmpty()) {
                subgraph.addAttributeNodes(fields.toArray(new String[fields.size()]));
            }
            Map<String, org.glassfish.jersey.message.filtering.spi.ObjectGraph> subgraphs = entityGraph.getSubgraphs();
            Class<?> subEntityClass = entityGraph.getEntityClass();
            String processedSubgraph = this.getProcessedSubgraph(entityClass, entry.getKey(), subEntityClass);
            if (subgraphs.isEmpty() || processed.contains(processedSubgraph)) continue;
            processed.add(processedSubgraph);
            this.createSubgraphs(subgraph, subEntityClass, subgraphs, processed);
        }
    }

    private String getProcessedSubgraph(Class<?> parent, String field, Class<?> fieldClass) {
        return parent.getName() + "_" + field + "_" + fieldClass.getName();
    }

    static {
        try {
            JAXB_CONTEXT = JAXBHelper.getJAXBContext(JAXBContextFactory.createContext(new TypeMappingInfo[0], Collections.emptyMap(), null));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

