/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;

public class SignatureVisitorImpl
implements SignatureVisitor {
    private final TypeBuilder typeBuilder;
    private final Stack<ParameterizedInterfaceModelImpl> stack = new Stack();
    private final Map<String, ParameterizedInterfaceModelImpl> formalTypes = new HashMap<String, ParameterizedInterfaceModelImpl>();
    private final Stack<String> formalTypesNames = new Stack();
    private final List<ParameterizedInterfaceModelImpl> parameterizedIntf = new ArrayList<ParameterizedInterfaceModelImpl>();

    public SignatureVisitorImpl(TypeBuilder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    Collection<ParameterizedInterfaceModelImpl> getImplementedInterfaces() {
        return Collections.unmodifiableCollection(this.parameterizedIntf);
    }

    @Override
    public void visitFormalTypeParameter(String s) {
        this.formalTypesNames.push(s);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        return this;
    }

    @Override
    public void visitBaseType(char c) {
    }

    @Override
    public void visitTypeVariable(String s) {
        String interfaceName;
        TypeProxy<InterfaceModel> interfaceTypeProxy;
        if (this.formalTypes.containsKey(s) && (interfaceTypeProxy = this.typeBuilder.getHolder(interfaceName = this.formalTypes.get(s).getName(), InterfaceModel.class)) != null) {
            ParameterizedInterfaceModelImpl childParameterized = new ParameterizedInterfaceModelImpl(interfaceTypeProxy);
            if (!this.stack.empty()) {
                this.stack.peek().addParameterizedType(childParameterized);
            }
        }
    }

    @Override
    public SignatureVisitor visitArrayType() {
        return this;
    }

    @Override
    public void visitClassType(String s) {
        String interfaceName = Type.getObjectType(s).getClassName();
        TypeProxy<InterfaceModel> interfaceTypeProxy = this.typeBuilder.getHolder(interfaceName, InterfaceModel.class);
        if (interfaceTypeProxy != null) {
            ParameterizedInterfaceModelImpl childParameterized = new ParameterizedInterfaceModelImpl(interfaceTypeProxy);
            if (!s.equals("java/lang/Object")) {
                if (this.formalTypesNames.empty()) {
                    if (!this.stack.empty()) {
                        this.stack.peek().addParameterizedType(childParameterized);
                    }
                } else {
                    this.formalTypes.put(this.formalTypesNames.pop(), childParameterized);
                }
            }
            this.stack.push(childParameterized);
        }
    }

    @Override
    public void visitInnerClassType(String s) {
    }

    @Override
    public void visitTypeArgument() {
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c) {
        return this;
    }

    @Override
    public void visitEnd() {
        if (this.stack.empty()) {
            return;
        }
        ParameterizedInterfaceModelImpl lastElement = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.parameterizedIntf.add(lastElement);
        }
    }
}

