/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.afterinvocation;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acls.afterinvocation.Filterer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayFilterer<T>
implements Filterer<T> {
    protected static final Log logger = LogFactory.getLog(ArrayFilterer.class);
    private final Set<T> removeList;
    private final T[] list;

    ArrayFilterer(T[] list) {
        this.list = list;
        this.removeList = new HashSet<T>();
    }

    public T[] getFilteredObject() {
        int originalSize = this.list.length;
        int sizeOfResultingList = originalSize - this.removeList.size();
        Object[] filtered = (Object[])Array.newInstance(this.list.getClass().getComponentType(), sizeOfResultingList);
        int j = 0;
        for (int i = 0; i < this.list.length; ++i) {
            T object = this.list[i];
            if (this.removeList.contains(object)) continue;
            filtered[j] = object;
            ++j;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Original array contained " + originalSize + " elements; now contains " + sizeOfResultingList + " elements");
        }
        return filtered;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ArrayFilterer.this.list.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ArrayFilterer.this.list[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void remove(T object) {
        this.removeList.add(object);
    }
}

